// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     BinaryStream.h
// CREATED:   3 Oct 2001 by Carl Muller
// MODIFIED: 24 Oct 2001 by Carl Muller
//
// This file defines a file class that supports fast reading and
// writing of binary files.
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
// Base functions required for binary streams (abstract)
struct SimpleStream
{
	virtual bool CanRead() = 0;
	virtual bool CanWrite() = 0;
	virtual void WriteByte(int value) = 0;
	virtual int ReadByte() = 0;
};

// ----------------------------------------------------------------------------
// Build features onto a simple stream (abstract)
struct BinaryStream : public SimpleStream
{
	// Writing functions
	void WriteWord(long value)
	{ WriteByte(value >> 8); WriteByte(value); }
	void WriteIntelWord(long value)
	{ WriteByte(value); WriteByte(value >> 8); }
	void WriteIntelLong(long value)
	{ WriteByte(value); WriteByte(value >> 8);
	  WriteByte(value >> 16); WriteByte(value >> 24); }
	void WriteLong(long value)
	{ WriteByte(value >> 24); WriteByte(value >> 16);
	  WriteByte(value >> 8); WriteByte(value); }
	void WriteString(const wstring& sValue); // Store as UTF8
	void WriteString(const string& sValue)
	{
		string::const_iterator i;
		for (i = sValue.begin(); i != sValue.end(); ++i)
			WriteByte(*i);
	}
	void WriteString(LPCTSTR sValue)
	{ while (*sValue) WriteByte(*sValue++); }
	virtual void WriteBytes(const BYTE *buffer, long num)
	{ while ((num--) > 0) WriteByte(*buffer++); }

	// Reading functions
	long ReadWord();
	long ReadIntelWord();
	long ReadLong();
	long ReadIntelLong();
	wstring ReadString(const string& delimiter, const string& ignored, int* plastch); // Read in a UTF-8 string
	virtual void ReadBytes(BYTE *buffer, long num);
};
