// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     BufferedFile.h
// CREATED:  26 Mar 2001 by Carl Muller
// MODIFIED: 24 Oct 2001 by Carl Muller
//
// This file defines a file class that supports fast reading and
// writing of binary files.
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
class BufferedFile : public BinaryStream
{
public :
	BufferedFile();
	virtual ~BufferedFile();

	// Override SimpleStream functions
	bool CanRead()
	{
		return m_pFileBuffer && !m_WriteMode;
	}
	bool CanWrite()
	{
		return m_pFileBuffer && m_WriteMode;
	}
	void WriteByte(int value)
	{
		m_pFileBuffer[m_BufferIndex++] = BYTE(value);
		if (m_BufferIndex >= m_BufferSize)
			WriteBuffer();
	}
	int ReadByte()
	{
		if (m_FileBaseIndex + m_BufferIndex >= m_FileLength)
			return EOF;
		else
		{
			int NextChar = m_pFileBuffer[m_BufferIndex++];
			if (m_BufferIndex >= m_BufferSize)
				ReadBuffer();
			return NextChar;
		}
	}

	// Override BinaryStream functions
	virtual void ReadBytes(BYTE *buffer, long num);

	// General functions
	virtual HRESULT OpenWrite(const CFileName& filename, int newbufsize = 4096); // 0 = OK
	virtual HRESULT OpenRead(const CFileName& filename, int newbufsize = 4096);  // 0 = OK
	virtual HRESULT Close();

	// Writing functions
	long GetPos() { return m_FileBaseIndex + m_BufferIndex; }
	HRESULT SetPos(long pos);

	// Reading functions
	bool EndOfFile()
	{	return (m_FileBaseIndex + m_BufferIndex >= m_FileLength);	}
	long GetLength() { return m_FileLength; }

private :
	// Helper functions
	BufferedFile(const BufferedFile &s);  // dummy copy constructor
	const BufferedFile& operator= (const BufferedFile&s);  // dummy assignment operator
	void ReadBuffer();
	HRESULT WriteBuffer();

private :
	// Variables
	bool m_WriteMode;
	int m_BufferSize;
	int m_BufferIndex;
	BYTE *m_pFileBuffer;
	long m_FileBaseIndex;
	long m_FileLength;  // For read files
	int m_FileHandle;
};
