// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     ChalkAnimation.cpp
// CREATED:  28 Apr 2000 by Carl Muller
// MODIFIED: 11 Jul 2000 by Carl Muller
//
// Implements class which describes positioned objects
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalkobjects.h"

// ----------------------------------------------------------------------------
// ChalkAnimation
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
ChalkAnimation::ChalkAnimation()  : ChalkObject(GUID_VOID, GUID_ANIMATION),
	m_GridX(8),
	m_GridY(8),
	m_Speed(6.0)
{
}

// ----------------------------------------------------------------------------
HRESULT ChalkAnimation::Write(ChalkStream& os) const
{
	os.WriteElement1("Animation");
	os.WriteInteger("gridx", m_GridX);
	os.WriteInteger("gridy", m_GridY);
	os.WriteReal("speed", m_Speed);
	os.WriteString("background", m_KidName.Get().c_str());
	{
		os.WriteElement("SpriteDefnFiles", m_DefnNames.size());
		vector<CFileName>::const_iterator i;
		for (i = m_DefnNames.begin(); i != m_DefnNames.end(); ++i)
		{
			os.WriteString("spritefile", i->Get().c_str());
		}
		os.WriteEndElement("SpriteDefnFiles");
	}
	{
		os.WriteElement("Frames", m_Frames.size());
		vector<ChalkFrame>::const_iterator i;
		for (i = m_Frames.begin(); i != m_Frames.end(); ++i)
		{
			i->Write(os);
		}
		os.WriteEndElement("Frames");
	}
	os.WriteEndElement("Animation");
	return S_OK;
}


// ----------------------------------------------------------------------------
HRESULT ChalkAnimation::Read(ChalkStream& is)
{
	is.ReadElement1("Animation");
	m_GridX = is.ReadInteger("gridx");
	m_GridY = is.ReadInteger("gridy");
	m_Speed = is.ReadReal("speed");
	m_KidName = is.ReadString("background");
	{
		int n = is.ReadElement("SpriteDefnFiles");
		m_DefnNames.clear();
		for (int i = 0; i < n; ++i)
		{
			wstring item = is.ReadString("spritefile");
			m_DefnNames.push_back(CFileName(item));
		}
		is.ReadEndElement("SpriteDefnFiles");
	}
	{
		int n = is.ReadElement("Frames");
		m_Frames.clear();
		for (int i = 0; i < n; ++i)
		{
			ChalkFrame item;
			item.Read(is);
			m_Frames.push_back(item);
		}
		is.ReadEndElement("Frames");
	}
	is.ReadEndElement("Animation");
	return S_OK;
}

// ----------------------------------------------------------------------------
// Does this class support this alternative file format?
bool ChalkAnimation::SupportsFile(const CFileName& filename)
{
	if (filename.HasExt(FILEEXTENSION_BOX))
		return true;
	if (filename.HasExt(FILEEXTENSION_FRK))
		return true;
	return false;
}

// ----------------------------------------------------------------------------
// Distribute the read alternative file command
HRESULT ChalkAnimation::ReadFile(const CFileName& filename)
{
	m_FileName = filename.Get();
	if (filename.HasExt(FILEEXTENSION_XML))
	{
		HRESULT hr = ReadXML(filename);
		if (hr == S_OK)
		{
			hr = LoadBlocks();
		}
		return hr;
	}
	if (filename.HasExt(FILEEXTENSION_BOX))
		return ReadBOX(filename);
	if (filename.HasExt(FILEEXTENSION_FRK))
		return ReadFRK(filename);
	m_FileName.Clear();
	return E_NOTIMPL;
}

// ----------------------------------------------------------------------------
// Distribute the write alternative file command
HRESULT ChalkAnimation::WriteFile(const CFileName& filename) const
{
	m_FileName = filename.Get();
	if (filename.HasExt(FILEEXTENSION_XML))
		return WriteXML(filename);
	if (filename.HasExt(FILEEXTENSION_BOX))
		return WriteBOX(filename);
	if (filename.HasExt(FILEEXTENSION_FRK))
		return WriteFRK(filename);
	m_FileName.Clear();
	return E_NOTIMPL;
}
