// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     ChalkDisplay.h
// CREATED:  28 Apr 2000 by Carl Muller
// MODIFIED: 01 Apr 2001 by Carl Muller
//
// Support drawing operations
// ----------------------------------------------------------------------------

typedef DWORD PIXEL; // 32 bit colour mode

// ----------------------------------------------------------------------------
class ChalkDisplay
{
public:
	ChalkDisplay();
	~ChalkDisplay();

	// For the view class
	void SetBitmapSize(CSize size, CScrollView* pView); // Set by the view
	void StartPaintScene(); // (paired) Attach to bitmap so that GDI functions (like text) work
	void EndPaintScene(CRect bounds, CDC *pDC); // (paired) Can be called by a view class
	void SetBounds(CPoint offset, CRect bounds); // To let the layer classes call my helper functions

	// For the layer classes
	void SetZoom(int zoommult, int zoomdiv);
	float GetZoom() { return m_Zoom; }
	int GetZoomMult() { return m_ZoomMult; }
	int GetZoomDiv() { return m_ZoomDiv; }
	CSize GetBitmapSize();
	PIXEL* m_pBits;
	// For the layer classes - these functions are restricted by bounds
	void DrawBox(CRect box, CRect border, PIXEL colour);
	void DrawLine(CPoint pt1, CPoint pt2, PIXEL colour);
	void DrawText(CPoint pt, int fontheight, PIXEL colour, const wstring& textstring);
	void Flush();

private:
	// Device Context Attributes
	CDC* m_pMemDC;
	CBitmap* m_pOldBitmap;

	// Bitmap Attributes
	CBitmap m_Bitmap; // The DIB section
	int m_BitmapWidth, m_BitmapHeight; // Copy of the size of the DIB section

	// Font Attributes
	CFont m_Font;
	CFont* m_pOldFont;
	bool m_Selected;
	int m_FontHeight;
	PIXEL m_FontColour;

	// Bounds attributes
	CPoint m_Offset;
	CRect m_Bounds;
	float m_Zoom; // Zoom in/out
	BOOL m_IsZoomed; // m_Zoom != 1.0f
	int m_ZoomMult; // >1 = zoom in
	int m_ZoomDiv; // >1 = zoom out
};
