// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     ChalkDocument.cpp
// CREATED:  16 Oct 2001 by Carl Muller
// MODIFIED: 16 Oct 2001 by Carl Muller
//
// This implements the per-document chalk information
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalkObj.h"

// ----------------------------------------------------------------------------
// ChalkDocument
// ----------------------------------------------------------------------------

const int MAX_CHUNK_SIZE = 65536;
const int MAX_UNDO_SIZE = 65536;


// ----------------------------------------------------------------------------
// Constructor
ChalkDocument::ChalkDocument() :
	m_BeforeBuffer(),
	m_AfterBuffer(),
	m_UndoBuffer(),
	m_Before(m_BeforeBuffer),
	m_After(m_AfterBuffer),
	m_Undo(m_UndoBuffer)
{
	m_UndoBuffer.Open(MAX_UNDO_SIZE);
}

// ----------------------------------------------------------------------------
// Call this before deleting an object
void ChalkDocument::RememberDelete(ChalkObject& object)
{
	object.m_Dirty = true;
}

// ----------------------------------------------------------------------------
// Call this after creating an object
void ChalkDocument::RememberAdd(ChalkObject& object)
{
	object.m_Dirty = true;
}

// ----------------------------------------------------------------------------
// Call this before changing an object
void ChalkDocument::RememberBegin(ChalkObject& object, LPCTSTR operation)
{
	object.m_Dirty = true;
	m_BeforeBuffer.Open(MAX_CHUNK_SIZE);
	object.Write(m_Before);
}

// ----------------------------------------------------------------------------
// Call this after changing an object
void ChalkDocument::RememberEnd(ChalkObject& object)
{
	m_AfterBuffer.Open(MAX_CHUNK_SIZE);
	object.Write(m_After);
	// Find delta between the before buffer and the after buffer
	// ...
	// Insert the delta into the undo buffer
	// Close
	m_AfterBuffer.Close();
	m_BeforeBuffer.Close();
}

// ----------------------------------------------------------------------------
void ChalkDocument::RememberBeginGroup(LPCTSTR operation)
{
}

// ----------------------------------------------------------------------------
void ChalkDocument::RememberEndGroup()
{
}
