// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     ChalkLayerPalette.cpp
// CREATED:   5 Jul 2000 by Carl Muller
// MODIFIED:  6 Jul 2000 by Carl Muller
//
// Implements visible objects
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalkDoc.h"
#include "chalkView.h"
#include "PropSheetBase.h"
#include "resource.h"


// ----------------------------------------------------------------------------
// ChalkLayerPaletteBars
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
ChalkLayerPaletteBars::ChalkLayerPaletteBars(CChalkDoc& Doc) :
	ChalkLayer(Doc)
{
	m_TypeName = _T("Palette Bars");
	m_pBaseData = &m_Data;
	m_DrawCommandsSupported = drawcmd_layer_properties;
}

// ----------------------------------------------------------------------------
ChalkLayerPaletteBars::~ChalkLayerPaletteBars()
{
}

// ----------------------------------------------------------------------------
// Draw a palette layer - this is a colour bar
void ChalkLayerPaletteBars::Draw(ChalkDisplay& display, CRect rt)
{
	int bitmapwidth = display.GetBitmapSize().cx;
	PIXEL *pRow = display.m_pBits;
	int palettesize = m_Data.m_NumColours;
	int srcy, dsty;
	int zoommult = display.GetZoomMult();
	int zoomdiv = display.GetZoomDiv();

	// Clear the bitmap to multicoloured value
	for (dsty = rt.top; dsty < rt.bottom; ++dsty )
	{
		PIXEL value = COLOUR_DKGREY;
		if (palettesize > 0)
		{
			srcy = dsty * zoomdiv / zoommult;
			if (srcy < palettesize)
				value = m_Data.m_Data[srcy];
		}

		PIXEL *pPixel = pRow;
		int n = rt.right - rt.left;
		if (n > 0)
			while (n--)
				*pPixel++ = value; // Colour line
		pRow += bitmapwidth;
	}
}

// ----------------------------------------------------------------------------
CSize ChalkLayerPaletteBars::GetSize()
{
	return CSize(0, m_Data.m_NumColours);
}


// ----------------------------------------------------------------------------
// Returns pointer to my palette object
ChalkPalette* ChalkLayerPaletteBars::GetPalette()
{
	return &m_Data;
}


// ----------------------------------------------------------------------------
// Perform a drawing command
void ChalkLayerPaletteBars::EditCommand(DrawCommands cmd)
{
	switch (cmd) {
	case drawcmd_layer_properties:
		{
			CPropertySheetPalette dlg(&m_Data, &m_Doc);
			dlg.DoModal();
		}
		break;

	default:
		AfxMessageBox(IDS_ERROR_NOTIMPLEMENTED);
		break;
	};
}
