// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     ChalkSample.h
// CREATED:  30 Apr 2000 by Carl Muller
// MODIFIED: 30 Apr 2000 by Carl Muller
//
// Defines the sound sample objects
// ----------------------------------------------------------------------------

#include "chalkobjects.h"

// ----------------------------------------------------------------------------
// Where is the speaker position for this sample?
typedef enum ChannelPosition {
	position_solo,
	position_right,
	position_left,
	position_centre,
	position_backleft,
	position_backright,
};

// ----------------------------------------------------------------------------
// A single sample set
class ChalkSampleChannel: public ChalkObject
{
public:
	ChalkSampleChannel();

	// Support ChalkObject interface
	HRESULT Write(ChalkStream& os) const;
	HRESULT Read(ChalkStream& is);

public:	// Data members
	vector<int, int&> m_Data; // Data for this channel
	ChannelPosition m_Channel; // Right, left, etc.
	int m_SampleSpeed; // Samples per second e.g. 44100 for the base frequency
	int m_RangeLow;    // Minimum samples per second for this sample
	int m_RangeHigh;   // Maximum samples per second for this sample
};

// ----------------------------------------------------------------------------
class ChalkSampleSet: public ChalkObject
{
public:
	ChalkSampleChannel();

	// Support ChalkObject interface
	HRESULT Write(ChalkStream& os) const;
	HRESULT Read(ChalkStream& is);

	// Support alternative file formats
	HRESULT ReadSVX(const CFileName& filename);
	HRESULT WriteSVX(const CFileName& filename);
	HRESULT ReadAIF(const CFileName& filename);
	HRESULT WriteAIFSVX(const CFileName& filename);
	HRESULT ReadWAV(const CFileName& filename);
	HRESULT WriteWAV(const CFileName& filename);
	HRESULT ReadRAW(const CFileName& filename);
	HRESULT WriteRAW(const CFileName& filename);

public:	// Data members
	vector<ChalkSampleChannel, ChalkSampleChannel&> m_Data; // All the channels
};
