// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     MainFrm.cpp
// CREATED:  28 Apr 2000 by Carl Muller
// MODIFIED:  5 Apr 2001 by Carl Muller
//
// Implementation of the CMainFrame class
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalk.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ----------------------------------------------------------------------------
// CMainFrame
IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_VIEW_DRAWTOOLBAR, OnViewDrawtoolbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_DRAWTOOLBAR, OnUpdateViewDrawtoolbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ANIMATIONTOOLBAR, OnUpdateViewAnimationtoolbar)
	ON_COMMAND(ID_VIEW_ANIMATIONTOOLBAR, OnViewAnimationtoolbar)
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_FINDER, CMDIFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CMDIFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CMDIFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CMDIFrameWnd::OnHelpFinder)
END_MESSAGE_MAP()

// ----------------------------------------------------------------------------
static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_STATUS_LAYER,
	ID_STATUS_FRAME,
	ID_STATUS_ZOOM,
	ID_STATUS_POSITION,
	ID_STATUS_TYPE,
};

// ----------------------------------------------------------------------------
// CMainFrame construction/destruction
CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	
}

// ----------------------------------------------------------------------------
CMainFrame::~CMainFrame()
{
}

// ----------------------------------------------------------------------------
int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create main toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndDrawToolBar.Create(this) ||
		!m_wndDrawToolBar.LoadToolBar(IDR_DRAWING))
	{
		TRACE0("Failed to create drawing toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndAnimToolBar.Create(this) ||
		!m_wndAnimToolBar.LoadToolBar(IDR_ANIMATION))
	{
		TRACE0("Failed to create animation toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
	m_wndDrawToolBar.SetBarStyle(m_wndDrawToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
	m_wndAnimToolBar.SetBarStyle(m_wndAnimToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	return 0;
}

// ----------------------------------------------------------------------------
// Dock the toolbars
void CMainFrame::DockToolBars()
{
	// Dock the toolbars in the same row at the top of the window
	CRect rt1;
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndDrawToolBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndAnimToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	
	DockControlBar(&m_wndAnimToolBar, AFX_IDW_DOCKBAR_TOP); // Dock second toolbar first
	m_wndAnimToolBar.GetWindowRect(&rt1); // Find out its dock position
	DockControlBar(&m_wndDrawToolBar, AFX_IDW_DOCKBAR_TOP, &rt1); // Insert first toolbar in front of it
	DockControlBar(&m_wndToolBar, AFX_IDW_DOCKBAR_TOP, &rt1); // Insert first toolbar in front of it
}


// ----------------------------------------------------------------------------
BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CMDIFrameWnd::PreCreateWindow(cs);
}

// ----------------------------------------------------------------------------
// CMainFrame diagnostics
#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG


// ----------------------------------------------------------------------------
void CMainFrame::OnViewDrawtoolbar() 
{
	CControlBar* pBar = &m_wndDrawToolBar;
	ShowControlBar(pBar, (pBar->GetStyle() & WS_VISIBLE) == 0, FALSE);
}

// ----------------------------------------------------------------------------
void CMainFrame::OnUpdateViewDrawtoolbar(CCmdUI* pCmdUI) 
{
	CControlBar* pBar = &m_wndDrawToolBar;
	pCmdUI->SetCheck((pBar->GetStyle() & WS_VISIBLE) != 0);
}

// ----------------------------------------------------------------------------
void CMainFrame::OnUpdateViewAnimationtoolbar(CCmdUI* pCmdUI) 
{
	CControlBar* pBar = &m_wndAnimToolBar;
	pCmdUI->SetCheck((pBar->GetStyle() & WS_VISIBLE) != 0);
}

// ----------------------------------------------------------------------------
void CMainFrame::OnViewAnimationtoolbar() 
{
	CControlBar* pBar = &m_wndAnimToolBar;
	ShowControlBar(pBar, (pBar->GetStyle() & WS_VISIBLE) == 0, FALSE);
}
