// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     MemoryBuffer.cpp
// CREATED:   3 Oct 2001 by Carl Muller
// MODIFIED: 16 Oct 2001 by Carl Muller
//
// This file defines a class that supports an in-memory buffer
// that can be read from/written to like a stream file.
// It is circular to that it has a fixed size.
// It is used for supporting Undo operations
// ----------------------------------------------------------------------------


#include "stdafx.h"
#include "binarystream.h"
#include "memorybuffer.h"


// ----------------------------------------------------------------------------
MemoryBuffer::MemoryBuffer() :
	m_BufferSize(0),
	m_pBuffer(NULL),
	m_BufferHead(0),
	m_BufferTail(0),
	m_BufferIndex(0)
{
}


// ----------------------------------------------------------------------------
MemoryBuffer::~MemoryBuffer()
{
	Close();
}

// ----------------------------------------------------------------------------
// Open a buffer
HRESULT MemoryBuffer::Open(int newbufsize)
{
	delete [] m_pBuffer;

	m_BufferSize = newbufsize;
	m_BufferHead = 0;
	m_BufferTail = 0;
	m_BufferIndex = 0;
	m_pBuffer = new BYTE[newbufsize];
	return S_OK;
}

// ----------------------------------------------------------------------------
// Close a buffer
HRESULT MemoryBuffer::Close()
{
	delete [] m_pBuffer;
	m_pBuffer = NULL;
	return S_OK;
}
