// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropDlgAnimation.cpp
// CREATED:   4 Jul 2000 by Carl Muller
// MODIFIED:  4 Jul 2000 by Carl Muller
//
// This implements the property page for animations
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalk.h"
#include "chalkDoc.h"
#include "chalkView.h"
#include "PropSheetBase.h"
#include "PropDlgAnimation.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ----------------------------------------------------------------------------
// CPropDlgAnimation property page
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
IMPLEMENT_DYNCREATE(CPropDlgAnimation, CPropertyPage)

// ----------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CPropDlgAnimation, CPropertyPage)
	//{{AFX_MSG_MAP(CPropDlgAnimation)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// ----------------------------------------------------------------------------
CPropDlgAnimation::CPropDlgAnimation() : CPropertyPage(CPropDlgAnimation::IDD)
{
	m_Dad = NULL;

	//{{AFX_DATA_INIT(CPropDlgAnimation)
	m_GridX = 0;
	m_GridY = 0;
	m_LimitDefns = 0;
	m_LimitFrames = 0;
	m_ParallaxX = 0.0;
	m_ParallaxY = 0.0;
	m_Speed = 0.0;
	//}}AFX_DATA_INIT
}

// ----------------------------------------------------------------------------
CPropDlgAnimation::~CPropDlgAnimation()
{
}

// ----------------------------------------------------------------------------
void CPropDlgAnimation::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropDlgAnimation)
	DDX_Text(pDX, IDC_GRID_X, m_GridX);
	DDX_Text(pDX, IDC_GRID_Y, m_GridY);
	DDX_Text(pDX, IDC_LIMIT_DEFNS, m_LimitDefns);
	DDX_Text(pDX, IDC_LIMIT_FRAMES, m_LimitFrames);
	DDX_Text(pDX, IDC_PARALLAX_X, m_ParallaxX);
	DDX_Text(pDX, IDC_PARALLAX_Y, m_ParallaxY);
	DDX_Text(pDX, IDC_SPEED, m_Speed);
	//}}AFX_DATA_MAP
}

// ----------------------------------------------------------------------------
void CPropDlgAnimation::Load(ChalkLayerAnimation* pData)
{
	if (!pData)
		return;
	m_GridX = pData->m_Data.m_GridX;
	m_GridY = pData->m_Data.m_GridY;
	m_LimitDefns = pData->m_Data.m_Font.m_Data.size();
	m_LimitFrames = pData->m_Data.m_Frames.size();
	m_ParallaxX = pData->m_RelativeX;
	m_ParallaxY = pData->m_RelativeY;
	m_Speed = pData->m_Data.m_Speed;
}

// ----------------------------------------------------------------------------
void CPropDlgAnimation::Save(ChalkLayerAnimation* pData)
{
	pData->m_Data.m_GridX = m_GridX;
	pData->m_Data.m_GridY = m_GridY;
	pData->m_RelativeX = m_ParallaxX;
	pData->m_RelativeY = m_ParallaxY;
	pData->m_Data.m_Speed = m_Speed;
}

// ----------------------------------------------------------------------------
BOOL CPropDlgAnimation::OnApply() 
{
	if (m_Dad)
		m_Dad->OnApply();
	return CPropertyPage::OnApply();
}

// ----------------------------------------------------------------------------
void CPropDlgAnimation::OnOK() 
{
	if (m_Dad)
		m_Dad->OnOK();
	CPropertyPage::OnOK();
}
