// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropDlgBitmap.cpp
// CREATED:   4 Jul 2000 by Carl Muller
// MODIFIED:  4 Jul 2000 by Carl Muller
//
// This implements the property page for animations
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalk.h"
#include "chalkDoc.h"
#include "chalkView.h"
#include "PropSheetBase.h"
#include "PropDlgBitmap.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ----------------------------------------------------------------------------
// CPropDlgBitmap property page
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
IMPLEMENT_DYNCREATE(CPropDlgBitmap, CPropertyPage)

// ----------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CPropDlgBitmap, CPropertyPage)
	//{{AFX_MSG_MAP(CPropDlgBitmap)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// ----------------------------------------------------------------------------
CPropDlgBitmap::CPropDlgBitmap() : CPropertyPage(CPropDlgBitmap::IDD)
{
	m_Dad = NULL;

	//{{AFX_DATA_INIT(CPropDlgBitmap)
	m_GridX = 0;
	m_GridY = 0;
	m_OffsetX = 0;
	m_OffsetY = 0;
	m_ParallaxX = 0.0;
	m_ParallaxY = 0.0;
	m_SizePlanes = 0;
	m_SizeX = 0;
	m_SizeY = 0;
	//}}AFX_DATA_INIT
}

// ----------------------------------------------------------------------------
CPropDlgBitmap::~CPropDlgBitmap()
{
}

// ----------------------------------------------------------------------------
void CPropDlgBitmap::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropDlgBitmap)
	DDX_Text(pDX, IDC_GRID_X, m_GridX);
	DDX_Text(pDX, IDC_GRID_Y, m_GridY);
	DDX_Text(pDX, IDC_OFFSET_X, m_OffsetX);
	DDX_Text(pDX, IDC_OFFSET_Y, m_OffsetY);
	DDX_Text(pDX, IDC_PARALLAX_X, m_ParallaxX);
	DDX_Text(pDX, IDC_PARALLAX_Y, m_ParallaxY);
	DDX_Text(pDX, IDC_SIZE_PLANES, m_SizePlanes);
	DDV_MinMaxInt(pDX, m_SizePlanes, 1, 32);
	DDX_Text(pDX, IDC_SIZE_X, m_SizeX);
	DDX_Text(pDX, IDC_SIZE_Y, m_SizeY);
	//}}AFX_DATA_MAP
}

// ----------------------------------------------------------------------------
void CPropDlgBitmap::Load(ChalkLayerBitmap* pData)
{
	if (!pData)
		return;
	m_SizePlanes = pData->m_Data.m_Character.m_NumPlanes;
	m_SizeX = pData->m_Data.m_Character.m_Width;
	m_SizeY = pData->m_Data.m_Character.m_Height;
	m_GridX = pData->m_Data.m_GridX;
	m_GridY = pData->m_Data.m_GridY;
	m_OffsetX = pData->m_Data.m_Character.m_OffsetX;
	m_OffsetY = pData->m_Data.m_Character.m_OffsetY;
	m_ParallaxX = pData->m_RelativeX;
	m_ParallaxY = pData->m_RelativeY;
}

// ----------------------------------------------------------------------------
void CPropDlgBitmap::Save(ChalkLayerBitmap* pData)
{
	pData->m_Data.m_GridX = m_GridX;
	pData->m_Data.m_GridY = m_GridY;
	pData->m_Data.m_Character.m_OffsetX = m_OffsetX;
	pData->m_Data.m_Character.m_OffsetY = m_OffsetY;
	pData->m_RelativeX = m_ParallaxX;
	pData->m_RelativeY = m_ParallaxY;

	// Support resizing the map
	if ((m_SizeX != pData->m_Data.m_Character.m_Width)
		|| (m_SizeY != pData->m_Data.m_Character.m_Height))
	{
		// Resize the bitmap
		pData->m_Data.m_Character.Resize(m_SizeX, m_SizeY);
		pData->m_Doc.CalcSize();
	}
}


// ----------------------------------------------------------------------------
BOOL CPropDlgBitmap::OnApply() 
{
	if (m_Dad)
		m_Dad->OnApply();
	return CPropertyPage::OnApply();
}

// ----------------------------------------------------------------------------
void CPropDlgBitmap::OnOK() 
{
	if (m_Dad)
		m_Dad->OnOK();
	CPropertyPage::OnOK();
}
