// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropDlgBox.cpp
// CREATED:   4 Jul 2000 by Carl Muller
// MODIFIED:  4 Jul 2000 by Carl Muller
//
// This implements the property page for sprites
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalk.h"
#include "chalkDoc.h"
#include "chalkView.h"
#include "PropSheetBase.h"
#include "PropDlgBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ----------------------------------------------------------------------------
// CPropDlgBox property page
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
IMPLEMENT_DYNCREATE(CPropDlgBox, CPropertyPage)

// ----------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CPropDlgBox, CPropertyPage)
	//{{AFX_MSG_MAP(CPropDlgBox)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// ----------------------------------------------------------------------------
CPropDlgBox::CPropDlgBox() : CPropertyPage(CPropDlgBox::IDD)
{
	m_Dad = NULL;

	//{{AFX_DATA_INIT(CPropDlgBox)
	m_BoxIndex = _T("");
	m_BoxShape = -1;
	m_BoxType = 0;
	m_OffsetX = 0;
	m_OffsetY = 0;
	m_OffsetZ = 0;
	m_PositionX = 0;
	m_PositionY = 0;
	m_PositionZ = 0;
	m_SizeX = 0;
	m_SizeY = 0;
	m_SizeZ = 0;
	//}}AFX_DATA_INIT
}

// ----------------------------------------------------------------------------
CPropDlgBox::~CPropDlgBox()
{
}

// ----------------------------------------------------------------------------
void CPropDlgBox::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropDlgBox)
	DDX_Text(pDX, IDC_BOX_INDEX, m_BoxIndex);
	DDX_CBIndex(pDX, IDC_BOXSHAPE, m_BoxShape);
	DDX_Text(pDX, IDC_BOXTYPE, m_BoxType);
	DDX_Text(pDX, IDC_OFFSET_X, m_OffsetX);
	DDX_Text(pDX, IDC_OFFSET_Y, m_OffsetY);
	DDX_Text(pDX, IDC_OFFSET_Z, m_OffsetZ);
	DDX_Text(pDX, IDC_POSITION_X, m_PositionX);
	DDX_Text(pDX, IDC_POSITION_Y, m_PositionY);
	DDX_Text(pDX, IDC_POSITION_Z, m_PositionZ);
	DDX_Text(pDX, IDC_SIZE_X, m_SizeX);
	DDX_Text(pDX, IDC_SIZE_Y, m_SizeY);
	DDX_Text(pDX, IDC_SIZE_Z, m_SizeZ);
	//}}AFX_DATA_MAP
}


// ----------------------------------------------------------------------------
void CPropDlgBox::Load(ChalkBox* pData)
{
	if (!pData)
		return;
	m_BoxIndex.Empty();
	m_BoxShape = pData->m_Shape;
	m_BoxType = pData->m_Type;
	m_OffsetX = pData->m_OffsetX;
	m_OffsetY = pData->m_OffsetY;
	m_OffsetZ = pData->m_OffsetZ;
	m_PositionX = pData->m_Xpos;
	m_PositionY = pData->m_Ypos;
	m_PositionZ = pData->m_Zpos;
	m_SizeX = pData->m_Width;
	m_SizeY = pData->m_Height;
	m_SizeZ = pData->m_Depth;
}

// ----------------------------------------------------------------------------
void CPropDlgBox::Save(ChalkBox* pData)
{
	pData->m_Shape = ShapeBox(m_BoxShape);
	pData->m_Type = m_BoxType;
	pData->m_OffsetX = m_OffsetX;
	pData->m_OffsetY = m_OffsetY;
	pData->m_OffsetZ = m_OffsetZ;
	pData->m_Xpos = m_PositionX;
	pData->m_Ypos = m_PositionY;
	pData->m_Zpos = m_PositionZ;
	pData->m_Width = m_SizeX;
	pData->m_Height = m_SizeY;
	pData->m_Depth = m_SizeZ;
}


// ----------------------------------------------------------------------------
BOOL CPropDlgBox::OnApply() 
{
	if (m_Dad)
		m_Dad->OnApply();
	return CPropertyPage::OnApply();
}

// ----------------------------------------------------------------------------
void CPropDlgBox::OnOK() 
{
	if (m_Dad)
		m_Dad->OnOK();
	CPropertyPage::OnOK();
}
