// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropDlgComment.cpp
// CREATED:   3 Jul 2000 by Carl Muller
// MODIFIED:  3 Jul 2000 by Carl Muller
//
// This defines the property page for all game objects
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalk.h"
#include "chalkDoc.h"
#include "chalkView.h"
#include "PropSheetBase.h"
#include "PropDlgComment.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ----------------------------------------------------------------------------
wstring WidenCString(const CString& value)
{
	// !!! not mbcs compliant
	wstring result;
	int i, n = value.GetLength();
	for (i = 0; i < n; ++i)
	{
		result += value[i];
	}
	return result;
}

// ----------------------------------------------------------------------------
// CPropDlgComment property page
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
IMPLEMENT_DYNCREATE(CPropDlgComment, CPropertyPage)

// ----------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CPropDlgComment, CPropertyPage)
	//{{AFX_MSG_MAP(CPropDlgComment)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// ----------------------------------------------------------------------------
CPropDlgComment::CPropDlgComment() : CPropertyPage(CPropDlgComment::IDD)
{
	m_Dad = NULL;

	//{{AFX_DATA_INIT(CPropDlgComment)
	m_Comment = _T("");
	m_Script = _T("");
	//}}AFX_DATA_INIT
}

// ----------------------------------------------------------------------------
CPropDlgComment::~CPropDlgComment()
{
}

// ----------------------------------------------------------------------------
void CPropDlgComment::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropDlgComment)
	DDX_Text(pDX, IDC_COMMENT, m_Comment);
	DDX_Text(pDX, IDC_SCRIPT, m_Script);
	//}}AFX_DATA_MAP
}


// ----------------------------------------------------------------------------
void CPropDlgComment::Load(ChalkObject *pData)
{
	if (!pData)
		return;
	m_Comment = pData->m_Comment.c_str();
	m_Script = pData->m_Script.c_str();
}




// ----------------------------------------------------------------------------
void CPropDlgComment::Save(ChalkObject *pData)
{
	if (!pData)
		return;
	pData->m_Comment = WidenCString(m_Comment);
	pData->m_Script = WidenCString(m_Script);
}

// ----------------------------------------------------------------------------
BOOL CPropDlgComment::OnApply() 
{
	if (m_Dad)
		m_Dad->OnApply();
	return CPropertyPage::OnApply();
}

// ----------------------------------------------------------------------------
void CPropDlgComment::OnOK() 
{
	if (m_Dad)
		m_Dad->OnOK();
	CPropertyPage::OnOK();
}

