// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropDlgFrame.cpp
// CREATED:   5 Jul 2000 by Carl Muller
// MODIFIED:  5 Apr 2001 by Carl Muller
//
// This defines the property page for an animation frame
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalk.h"
#include "chalkDoc.h"
#include "chalkView.h"
#include "PropSheetBase.h"
#include "PropDlgFrame.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ----------------------------------------------------------------------------
// CPropDlgFrame property page
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
IMPLEMENT_DYNCREATE(CPropDlgFrame, CPropertyPage)

// ----------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CPropDlgFrame, CPropertyPage)
	//{{AFX_MSG_MAP(CPropDlgFrame)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// ----------------------------------------------------------------------------
CPropDlgFrame::CPropDlgFrame() : CPropertyPage(CPropDlgFrame::IDD)
{
	m_Dad = NULL;

	//{{AFX_DATA_INIT(CPropDlgFrame)
	m_CurrentFrame = 0;
	m_LimitBoxes = 0;
	m_LimitFrame = 0;
	m_LimitPaths = 0;
	m_LimitSprites = 0;
	//}}AFX_DATA_INIT
}

// ----------------------------------------------------------------------------
CPropDlgFrame::~CPropDlgFrame()
{
}

// ----------------------------------------------------------------------------
void CPropDlgFrame::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropDlgFrame)
	DDX_Text(pDX, IDC_CURRENT_FRAME, m_CurrentFrame);
	DDX_Text(pDX, IDC_LIMIT_BOXES, m_LimitBoxes);
	DDX_Text(pDX, IDC_LIMIT_FRAME, m_LimitFrame);
	DDX_Text(pDX, IDC_LIMIT_PATHS, m_LimitPaths);
	DDX_Text(pDX, IDC_LIMIT_SPRITES, m_LimitSprites);
	//}}AFX_DATA_MAP
}

// ----------------------------------------------------------------------------
void CPropDlgFrame::Load(ChalkAnimation *pData, int currentframe)
{
	if (!pData)
		return;
	m_CurrentFrame = currentframe + 1;
	m_LimitFrame = pData->m_Frames.size();
	ChalkFrame& frame = pData->m_Frames[currentframe];
	m_LimitBoxes = frame.m_Boxes.size();
	m_LimitPaths = frame.m_Paths.size();
	m_LimitSprites = frame.m_Sprites.size();
}

// ----------------------------------------------------------------------------
void CPropDlgFrame::Save(ChalkAnimation *pData, int* pcurrentframe)
{
	if (!pData)
		return;
	if (pcurrentframe)
		*pcurrentframe = max(0, min(m_CurrentFrame - 1, m_LimitFrame - 1));
}

// ----------------------------------------------------------------------------
BOOL CPropDlgFrame::OnApply() 
{
	if (m_Dad)
		m_Dad->OnApply();
	return CPropertyPage::OnApply();
}

// ----------------------------------------------------------------------------
void CPropDlgFrame::OnOK() 
{
	if (m_Dad)
		m_Dad->OnOK();
	CPropertyPage::OnOK();
}
