// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropDlgGeneral.cpp
// CREATED:   3 Jul 2000 by Carl Muller
// MODIFIED:  3 Jul 2000 by Carl Muller
//
// This defines the property page for all game objects
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalk.h"
#include "chalkDoc.h"
#include "chalkView.h"
#include "PropSheetBase.h"
#include "PropDlgGeneral.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ----------------------------------------------------------------------------
// CPropDlgGeneral property page
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
IMPLEMENT_DYNCREATE(CPropDlgGeneral, CPropertyPage)

// ----------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CPropDlgGeneral, CPropertyPage)
	//{{AFX_MSG_MAP(CPropDlgGeneral)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// ----------------------------------------------------------------------------
CPropDlgGeneral::CPropDlgGeneral() : CPropertyPage(CPropDlgGeneral::IDD)
{
	m_Dad = NULL;

	//{{AFX_DATA_INIT(CPropDlgGeneral)
	m_CreatedComputer = _T("");
	m_CreatedDate = COleDateTime::GetCurrentTime();
	m_CreatedUser = _T("");
	m_ObjectDirty = FALSE;
	m_ObjectFilename = _T("");
	m_ObjectGUID = _T("");
	m_ObjectSelected = FALSE;
	m_ObjectTypename = _T("");
	m_ModifiedComputer = _T("");
	m_ModifiedUser = _T("");
	m_ModifiedDate = COleDateTime::GetCurrentTime();
	//}}AFX_DATA_INIT
}

// ----------------------------------------------------------------------------
CPropDlgGeneral::~CPropDlgGeneral()
{
}

// ----------------------------------------------------------------------------
void CPropDlgGeneral::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropDlgGeneral)
	DDX_Text(pDX, IDC_CREATED_COMPUTER, m_CreatedComputer);
	DDX_Text(pDX, IDC_CREATED_DATE, m_CreatedDate);
	DDX_Text(pDX, IDC_CREATED_USER, m_CreatedUser);
	DDX_Check(pDX, IDC_DIRTY, m_ObjectDirty);
	DDX_Text(pDX, IDC_FILENAME, m_ObjectFilename);
	DDX_Text(pDX, IDC_GUID, m_ObjectGUID);
	DDX_Check(pDX, IDC_SELECTED, m_ObjectSelected);
	DDX_Text(pDX, IDC_TYPENAME, m_ObjectTypename);
	DDX_Text(pDX, IDC_MODIFIED_COMPUTER, m_ModifiedComputer);
	DDX_Text(pDX, IDC_MODIFIED_USER, m_ModifiedUser);
	DDX_Text(pDX, IDC_MODIFIED_DATE, m_ModifiedDate);
	//}}AFX_DATA_MAP
}

// ----------------------------------------------------------------------------
void CPropDlgGeneral::Load(ChalkObject* pData)
{
	if (!pData)
		return;
	m_CreatedDate = pData->m_DateCreated;
	m_CreatedUser = pData->m_UserCreated.c_str();
	m_CreatedComputer = pData->m_ComputerCreated.c_str();
	m_ModifiedDate = pData->m_DateModified;
	m_ModifiedUser = pData->m_UserModified.c_str();
	m_ModifiedComputer = pData->m_ComputerModified.c_str();

	m_ObjectDirty = pData->m_Dirty;
	m_ObjectFilename = pData->m_FileName.Get().c_str();
	m_ObjectGUID.Format(_T("{%08lx-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x}"),
		pData->m_Id.Data1, pData->m_Id.Data2, pData->m_Id.Data3,
		pData->m_Id.Data4[0], pData->m_Id.Data4[1],
		pData->m_Id.Data4[2], pData->m_Id.Data4[3],
		pData->m_Id.Data4[4], pData->m_Id.Data4[5],
		pData->m_Id.Data4[6], pData->m_Id.Data4[7]);
	m_ObjectSelected = pData->m_Selected;
	m_ObjectTypename = g_ChalkObjectMap.GetTypeName(pData->m_TypeId).c_str();
}

// ----------------------------------------------------------------------------
void CPropDlgGeneral::Save(ChalkObject* pData)
{
	pData->m_Selected = (m_ObjectSelected != 0);
}

// ----------------------------------------------------------------------------
BOOL CPropDlgGeneral::OnApply() 
{
	if (m_Dad)
		m_Dad->OnApply();
	return CPropertyPage::OnApply();
}

// ----------------------------------------------------------------------------
void CPropDlgGeneral::OnOK() 
{
	if (m_Dad)
		m_Dad->OnOK();
	CPropertyPage::OnOK();
}

