// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropDlgMap.cpp
// CREATED:  11 Jul 2000 by Carl Muller
// MODIFIED: 11 Jul 2000 by Carl Muller
//
// This implements the property page for a map
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalk.h"
#include "chalkDoc.h"
#include "chalkView.h"
#include "PropSheetBase.h"
#include "PropDlgMap.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ----------------------------------------------------------------------------
// CPropDlgMap property page
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
IMPLEMENT_DYNCREATE(CPropDlgMap, CPropertyPage)

// ----------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CPropDlgMap, CPropertyPage)
	//{{AFX_MSG_MAP(CPropDlgMap)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// ----------------------------------------------------------------------------
CPropDlgMap::CPropDlgMap() : CPropertyPage(CPropDlgMap::IDD)
{
	m_Dad = NULL;

	//{{AFX_DATA_INIT(CPropDlgMap)
	m_Speed = 0.0;
	m_GridX = 0;
	m_GridY = 0;
	m_ParallaxX = 0.0;
	m_ParallaxY = 0.0;
	m_BlockX = 0;
	m_BlockY = 0;
	m_NumFrames = 0;
	m_SizeX = 0;
	m_SizeY = 0;
	m_System = _T("");
	//}}AFX_DATA_INIT
}

// ----------------------------------------------------------------------------
CPropDlgMap::~CPropDlgMap()
{
}

// ----------------------------------------------------------------------------
void CPropDlgMap::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropDlgMap)
	DDX_Text(pDX, IDC_ANIMATION_SPEED, m_Speed);
	DDX_Text(pDX, IDC_GRID_X, m_GridX);
	DDX_Text(pDX, IDC_GRID_Y, m_GridY);
	DDX_Text(pDX, IDC_PARALLAX_X, m_ParallaxX);
	DDX_Text(pDX, IDC_PARALLAX_Y, m_ParallaxY);
	DDX_Text(pDX, IDC_BLOCK_X, m_BlockX);
	DDX_Text(pDX, IDC_BLOCK_Y, m_BlockY);
	DDX_Text(pDX, IDC_NUM_FRAMES, m_NumFrames);
	DDX_Text(pDX, IDC_SIZE_X, m_SizeX);
	DDX_Text(pDX, IDC_SIZE_Y, m_SizeY);
	DDX_Text(pDX, IDC_SYSTEM, m_System);
	//}}AFX_DATA_MAP
}

// ----------------------------------------------------------------------------
void CPropDlgMap::Load(ChalkLayerMap* pData)
{
	if (!pData)
		return;
	m_Speed = pData->m_Data.m_Speed;
	m_GridX = pData->m_Data.m_Grid2X / pData->m_Data.m_Grid1X;
	m_GridY = pData->m_Data.m_Grid2Y / pData->m_Data.m_Grid1Y;
	m_ParallaxX = pData->m_RelativeX;
	m_ParallaxY = pData->m_RelativeY;
	m_BlockX = pData->m_Data.m_Grid1X;
	m_BlockY = pData->m_Data.m_Grid1Y;
	m_NumFrames = pData->m_Data.m_Data.size();
	if (m_NumFrames > 0)
	{
		m_SizeX = pData->m_Data.m_Data[0].m_Width;
		m_SizeY = pData->m_Data.m_Data[0].m_Height;
	}
	ChalkSystem* systemobject = static_cast<ChalkSystem *>(g_ChalkObjectMap.GetObject(pData->m_Data.m_SystemType));
	if (systemobject)
		m_System = systemobject->m_SystemName.c_str();
}

// ----------------------------------------------------------------------------
void CPropDlgMap::Save(ChalkLayerMap* pData)
{
	if (!pData)
		return;
	pData->m_Data.m_Speed = m_Speed;
	pData->m_Data.m_Grid2X = m_GridX * pData->m_Data.m_Grid1X;
	pData->m_Data.m_Grid2Y = m_GridY * pData->m_Data.m_Grid1Y;
	pData->m_RelativeX = m_ParallaxX;
	pData->m_RelativeY = m_ParallaxY;

	// Support resizing the map
	if (m_NumFrames > 0)
	{
		if (m_SizeX != pData->m_Data.m_Data[0].m_Width || 
			m_SizeY != pData->m_Data.m_Data[0].m_Height)
		{
			// Resize the maps
			int n = pData->m_Data.m_Data.size();
			for (int i = 0; i < n; ++i)
			{
				pData->m_Data.m_Data[i].Resize(m_SizeX, m_SizeY);
			}
		}
		pData->m_Doc.CalcSize();
	}
}

// ----------------------------------------------------------------------------
BOOL CPropDlgMap::OnApply() 
{
	if (m_Dad)
		m_Dad->OnApply();
	return CPropertyPage::OnApply();
}

// ----------------------------------------------------------------------------
void CPropDlgMap::OnOK() 
{
	if (m_Dad)
		m_Dad->OnOK();
	CPropertyPage::OnOK();
}
