// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropDlgMap.h
// CREATED:  11 Jul 2000 by Carl Muller
// MODIFIED: 11 Jul 2000 by Carl Muller
//
// This defines the property page for a map
// ----------------------------------------------------------------------------

#if !defined(AFX_PROPDLGMAP_H__34980FA0_5783_11D4_93A1_8BB2901638BA__INCLUDED_)
#define AFX_PROPDLGMAP_H__34980FA0_5783_11D4_93A1_8BB2901638BA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// ----------------------------------------------------------------------------
// CPropDlgMap dialog
class CPropDlgMap : public CPropertyPage
{
	DECLARE_DYNCREATE(CPropDlgMap)

// Construction
public:
	CPropDlgMap();
	~CPropDlgMap();
	void Load(ChalkLayerMap *pData);
	void Save(ChalkLayerMap *pData);

// Dialog Data
	CPropertySheetBase *m_Dad;

	//{{AFX_DATA(CPropDlgMap)
	enum { IDD = IDD_PROPERTY_MAP };
	double	m_Speed;
	int		m_GridX;
	int		m_GridY;
	double	m_ParallaxX;
	double	m_ParallaxY;
	int		m_BlockX;
	int		m_BlockY;
	int		m_NumFrames;
	int		m_SizeX;
	int		m_SizeY;
	CString	m_System;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CPropDlgMap)
	public:
	virtual BOOL OnApply();
	virtual void OnOK();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CPropDlgMap)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

//{{AFX_INSERT_LOCATION}}

#endif // !defined(AFX_PROPDLGMAP_H__34980FA0_5783_11D4_93A1_8BB2901638BA__INCLUDED_)
