// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropDlgMapBlock.cpp
// CREATED:   4 Jul 2000 by Carl Muller
// MODIFIED:  4 Jul 2000 by Carl Muller
//
// This implements the property page for map blocks
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalk.h"
#include "chalkDoc.h"
#include "chalkView.h"
#include "PropSheetBase.h"
#include "PropDlgMapBlock.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ----------------------------------------------------------------------------
// CPropDlgMapBlock property page
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
IMPLEMENT_DYNCREATE(CPropDlgMapBlock, CPropertyPage)

// ----------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CPropDlgMapBlock, CPropertyPage)
	//{{AFX_MSG_MAP(CPropDlgMapBlock)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// ----------------------------------------------------------------------------
CPropDlgMapBlock::CPropDlgMapBlock() : CPropertyPage(CPropDlgMapBlock::IDD)
{
	m_Dad = NULL;

	//{{AFX_DATA_INIT(CPropDlgMapBlock)
	m_LimitAttribute = 0;
	m_LimitBlock = 0;
	m_LimitPalette = 0;
	m_NameAttribute = _T("");
	m_NameBlock = _T("");
	m_PositionColumn = _T("");
	m_PositionFrame = _T("");
	m_PositionRow = _T("");
	m_SpecialFlipX = FALSE;
	m_SpecialFlipY = FALSE;
	m_SpecialPriority = FALSE;
	m_ValueAttribute = 0;
	m_ValueBlock = 0;
	m_ValuePalette = 0;
	//}}AFX_DATA_INIT
}

// ----------------------------------------------------------------------------
CPropDlgMapBlock::~CPropDlgMapBlock()
{
}

// ----------------------------------------------------------------------------
void CPropDlgMapBlock::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropDlgMapBlock)
	DDX_Text(pDX, IDC_LIMIT_ATTRIBUTE, m_LimitAttribute);
	DDX_Text(pDX, IDC_LIMIT_BLOCK, m_LimitBlock);
	DDX_Text(pDX, IDC_LIMIT_PALETTE, m_LimitPalette);
	DDX_Text(pDX, IDC_NAME_ATTRIBUTE, m_NameAttribute);
	DDX_Text(pDX, IDC_NAME_BLOCK, m_NameBlock);
	DDX_Text(pDX, IDC_POSITION_COLUMN, m_PositionColumn);
	DDX_Text(pDX, IDC_POSITION_FRAME, m_PositionFrame);
	DDX_Text(pDX, IDC_POSITION_ROW, m_PositionRow);
	DDX_Check(pDX, IDC_SPECIAL_FLIPX, m_SpecialFlipX);
	DDX_Check(pDX, IDC_SPECIAL_FLIPY, m_SpecialFlipY);
	DDX_Check(pDX, IDC_SPECIAL_PRIORITY, m_SpecialPriority);
	DDX_Text(pDX, IDC_VALUE_ATTRIBUTE, m_ValueAttribute);
	DDX_Text(pDX, IDC_VALUE_BLOCK, m_ValueBlock);
	DDX_Text(pDX, IDC_VALUE_PALETTE, m_ValuePalette);
	//}}AFX_DATA_MAP
}


// ----------------------------------------------------------------------------
void CPropDlgMapBlock::Load(ChalkMapBlock* pData)
{
	if (!pData)
		return;
	m_LimitAttribute = 0;
	m_LimitBlock = 0;
	m_LimitPalette = 0;
	m_NameAttribute = _T("");
	m_NameBlock = _T("");
	m_PositionColumn = _T("");
	m_PositionFrame = _T("");
	m_PositionRow = _T("");

	m_ValueAttribute = pData->m_Attribute;
	m_ValueBlock = pData->m_BlockIndex;
	m_ValuePalette = pData->m_PaletteOffset;
	m_SpecialFlipX = pData->m_Special & SPECIAL_XFLIP ? true : false;
	m_SpecialFlipY = pData->m_Special & SPECIAL_YFLIP ? true : false;
	m_SpecialPriority = pData->m_Special & SPECIAL_PRIORITY ? true : false;
}

// ----------------------------------------------------------------------------
void CPropDlgMapBlock::Save(ChalkMapBlock* pData)
{
	pData->m_Attribute = m_ValueAttribute;
	pData->m_BlockIndex = m_ValueBlock;
	pData->m_PaletteOffset = m_ValuePalette;
	pData->m_Special = 
		(m_SpecialFlipX ? SPECIAL_XFLIP : 0) |
		(m_SpecialFlipY ? SPECIAL_YFLIP : 0) |
		(m_SpecialPriority ? SPECIAL_PRIORITY : 0);
}


// ----------------------------------------------------------------------------
BOOL CPropDlgMapBlock::OnApply() 
{
	if (m_Dad)
		m_Dad->OnApply();
	return CPropertyPage::OnApply();
}

// ----------------------------------------------------------------------------
void CPropDlgMapBlock::OnOK() 
{
	if (m_Dad)
		m_Dad->OnOK();
	CPropertyPage::OnOK();
}
