// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropDlgPalette.cpp
// CREATED:   6 Jul 2000 by Carl Muller
// MODIFIED: 16 Jul 2000 by Carl Muller
//
// This implements the property page for a palette
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalk.h"
#include "chalkDoc.h"
#include "chalkView.h"
#include "PropSheetBase.h"
#include "PropDlgPalette.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

enum {
	column_colourindex = 0,
	column_red,
	column_green,
	column_blue,
};

enum {
	column_rangeindex = 0,
	column_first,
	column_last,
	column_active,
	column_speed,
};

enum {
	displayformat_decimal,
	displayformat_hex,
	displayformat_percent,
};

// ----------------------------------------------------------------------------
// CPropDlgPalette property page
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
IMPLEMENT_DYNCREATE(CPropDlgPalette, CPropertyPage)

// ----------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CPropDlgPalette, CPropertyPage)
	//{{AFX_MSG_MAP(CPropDlgPalette)
	ON_CBN_EDITCHANGE(IDC_DISPLAY_FORMAT, OnEditchangeDisplayFormat)
	ON_CBN_SELCHANGE(IDC_DISPLAY_FORMAT, OnSelchangeDisplayFormat)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// ----------------------------------------------------------------------------
CPropDlgPalette::CPropDlgPalette() : CPropertyPage(CPropDlgPalette::IDD)
{
	m_Dad = NULL;
	m_pData = NULL;

	//{{AFX_DATA_INIT(CPropDlgPalette)
	m_LimitColours = 0;
	m_LimitRanges = 0;
	m_DisplayFormat = 0;
	//}}AFX_DATA_INIT
}

// ----------------------------------------------------------------------------
CPropDlgPalette::~CPropDlgPalette()
{
}

// ----------------------------------------------------------------------------
void CPropDlgPalette::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropDlgPalette)
	DDX_Control(pDX, IDC_LIST_RANGES, m_ListRanges);
	DDX_Control(pDX, IDC_LIST_COLOURS, m_ListColours);
	DDX_Text(pDX, IDC_LIMIT_COLOURS, m_LimitColours);
	DDX_Text(pDX, IDC_LIMIT_RANGES, m_LimitRanges);
	DDX_CBIndex(pDX, IDC_DISPLAY_FORMAT, m_DisplayFormat);
	//}}AFX_DATA_MAP
}


// ----------------------------------------------------------------------------
BOOL CPropDlgPalette::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	CString S;

	// Setup the list boxes
	S.LoadString(IDS_COLUMN_INDEX);
	m_ListColours.InsertColumn(column_colourindex, S, LVCFMT_LEFT, 30);
	S.LoadString(IDS_COLUMN_RED);
	m_ListColours.InsertColumn(column_red, S, LVCFMT_RIGHT, 50);
	S.LoadString(IDS_COLUMN_GREEN);
	m_ListColours.InsertColumn(column_green, S, LVCFMT_RIGHT, 50);
	S.LoadString(IDS_COLUMN_BLUE);
	m_ListColours.InsertColumn(column_blue, S, LVCFMT_RIGHT, 50);
	
	S.LoadString(IDS_COLUMN_INDEX);
	m_ListRanges.InsertColumn(column_rangeindex, S, LVCFMT_RIGHT, 30);
	S.LoadString(IDS_COLUMN_FIRST);
	m_ListRanges.InsertColumn(column_first, S, LVCFMT_RIGHT, 50);
	S.LoadString(IDS_COLUMN_LAST);
	m_ListRanges.InsertColumn(column_last, S, LVCFMT_RIGHT, 50);
	S.LoadString(IDS_COLUMN_ACTIVE);
	m_ListRanges.InsertColumn(column_active, S, LVCFMT_RIGHT, 50);
	S.LoadString(IDS_COLUMN_SPEED);
	m_ListRanges.InsertColumn(column_speed, S, LVCFMT_RIGHT, 50);

	// Load the values into the list boxes,
	// from previously recorded place
	if (m_pData)
	{
		int i;

		for (i = 0; i < m_LimitColours; ++i)
		{
			ChalkColour val = m_pData->m_Data[i];
			S.Format(FORMAT_DECIMAL, i);
			m_ListColours.InsertItem(i, S);
			// Other columns filled in by UpdateFormat()
		}
		for (i = 0; i < m_LimitRanges; ++i)
		{
			S.Format(FORMAT_DECIMAL, i);
			m_ListRanges.InsertItem(i, S);
			S.Format(FORMAT_DECIMAL, m_pData->m_ColourRanges[i].first);
			m_ListColours.SetItemText(i, column_first, S);
			S.Format(FORMAT_DECIMAL, m_pData->m_ColourRanges[i].last);
			m_ListColours.SetItemText(i, column_last, S);
			S.Format(FORMAT_DECIMAL, m_pData->m_ColourRanges[i].active);
			m_ListColours.SetItemText(i, column_active, S);
			S.Format(FORMAT_DECIMAL, m_pData->m_ColourRanges[i].rate);
			m_ListColours.SetItemText(i, column_speed, S);
		}
	}
	UpdateFormat();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

// ----------------------------------------------------------------------------
void CPropDlgPalette::Load(ChalkPalette* pData)
{
	if (!pData)
		return;

	m_pData = pData; // For later use
	m_LimitColours = pData->m_NumColours;
	m_LimitRanges = pData->m_ColourRanges.size();
}

// ----------------------------------------------------------------------------
void CPropDlgPalette::Save(ChalkPalette* pData)
{
	if (!pData)
		return;
}

// ----------------------------------------------------------------------------
// Update the numbers for the colours
void CPropDlgPalette::UpdateFormat()
{
	if (!m_pData)
		return;
	CString S;
	int i;

	for (i = 0; i < m_LimitColours; ++i)
	{
		ChalkColour val = m_pData->m_Data[i];
		int r = (val >> 16) & 0xff;
		int g = (val >> 8) & 0xff;
		int b = val & 0xff;
		switch (m_DisplayFormat) {
		case displayformat_decimal:
			S.Format(FORMAT_DECIMAL, r);
			m_ListColours.SetItemText(i, column_red, S);
			S.Format(FORMAT_DECIMAL, g);
			m_ListColours.SetItemText(i, column_green, S);
			S.Format(FORMAT_DECIMAL, b);
			m_ListColours.SetItemText(i, column_blue, S);
			break;

		case displayformat_hex:
			S.Format(FORMAT_HEX2, r);
			m_ListColours.SetItemText(i, column_red, S);
			S.Format(FORMAT_HEX2, g);
			m_ListColours.SetItemText(i, column_green, S);
			S.Format(FORMAT_HEX2, b);
			m_ListColours.SetItemText(i, column_blue, S);
			break;

		case displayformat_percent:
			S.Format(FORMAT_PERCENT, (r * 100L) / 255);
			m_ListColours.SetItemText(i, column_red, S);
			S.Format(FORMAT_PERCENT, (g * 100L) / 255);
			m_ListColours.SetItemText(i, column_green, S);
			S.Format(FORMAT_PERCENT, (b * 100L) / 255);
			m_ListColours.SetItemText(i, column_blue, S);
			break;
		};
	}
}

// ----------------------------------------------------------------------------
BOOL CPropDlgPalette::OnApply() 
{
	if (m_Dad)
		m_Dad->OnApply();
	return CPropertyPage::OnApply();
}

// ----------------------------------------------------------------------------
void CPropDlgPalette::OnOK() 
{
	if (m_Dad)
		m_Dad->OnOK();
	CPropertyPage::OnOK();
}

// ----------------------------------------------------------------------------
void CPropDlgPalette::OnEditchangeDisplayFormat() 
{
	UpdateData(TRUE);
	UpdateFormat();
}

// ----------------------------------------------------------------------------
void CPropDlgPalette::OnSelchangeDisplayFormat() 
{
	UpdateData(TRUE);
	UpdateFormat();
}
