// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropDlgPalette.h
// CREATED:   6 Jul 2000 by Carl Muller
// MODIFIED:  6 Jul 2000 by Carl Muller
//
// This defines the property page for a palette
// ----------------------------------------------------------------------------

#if !defined(AFX_PROPDLGPALETTE_H__47E28F60_537B_11D4_93A1_C691A0B20DBF__INCLUDED_)
#define AFX_PROPDLGPALETTE_H__47E28F60_537B_11D4_93A1_C691A0B20DBF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// ----------------------------------------------------------------------------
// CPropDlgPalette dialog
class CPropDlgPalette : public CPropertyPage
{
	DECLARE_DYNCREATE(CPropDlgPalette)

// Construction
public:
	CPropDlgPalette();
	~CPropDlgPalette();
	void Load(ChalkPalette *pData); // Delayed reaction (OnInitDialog)
	void Save(ChalkPalette *pData);
	void UpdateFormat();

// Dialog Data
	CPropertySheetBase *m_Dad;
	ChalkPalette *m_pData;

	//{{AFX_DATA(CPropDlgPalette)
	enum { IDD = IDD_PROPERTY_PALETTE };
	CListCtrl	m_ListRanges;
	CListCtrl	m_ListColours;
	int		m_LimitColours;
	int		m_LimitRanges;
	int		m_DisplayFormat;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CPropDlgPalette)
	public:
	virtual BOOL OnApply();
	virtual void OnOK();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CPropDlgPalette)
	virtual BOOL OnInitDialog();
	afx_msg void OnEditchangeDisplayFormat();
	afx_msg void OnSelchangeDisplayFormat();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

//{{AFX_INSERT_LOCATION}}

#endif // !defined(AFX_PROPDLGPALETTE_H__47E28F60_537B_11D4_93A1_C691A0B20DBF__INCLUDED_)
