// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropDlgPath.cpp
// CREATED:  11 Jul 2000 by Carl Muller
// MODIFIED: 11 Jul 2000 by Carl Muller
//
// This implements the property page for a path
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalk.h"
#include "chalkDoc.h"
#include "chalkView.h"
#include "PropSheetBase.h"
#include "PropDlgPath.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ----------------------------------------------------------------------------
// CPropDlgPath property page
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
IMPLEMENT_DYNCREATE(CPropDlgPath, CPropertyPage)

// ----------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CPropDlgPath, CPropertyPage)
	//{{AFX_MSG_MAP(CPropDlgPath)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// ----------------------------------------------------------------------------
CPropDlgPath::CPropDlgPath() : CPropertyPage(CPropDlgPath::IDD)
{
	m_Dad = NULL;

	//{{AFX_DATA_INIT(CPropDlgPath)
	m_Speed = 0.0;
	m_NumPoints = 0;
	m_SpriteName = _T("");
	m_PathType = 0;
	m_SpriteDefn = 0;
	//}}AFX_DATA_INIT
}

// ----------------------------------------------------------------------------
CPropDlgPath::~CPropDlgPath()
{
}

// ----------------------------------------------------------------------------
void CPropDlgPath::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropDlgPath)
	DDX_Text(pDX, IDC_ANIMATION_SPEED, m_Speed);
	DDX_Text(pDX, IDC_LIMIT_POINTS, m_NumPoints);
	DDX_Text(pDX, IDC_NAME_DEFN, m_SpriteName);
	DDX_Text(pDX, IDC_PATH_TYPE, m_PathType);
	DDX_Text(pDX, IDC_VALUE_DEFN, m_SpriteDefn);
	//}}AFX_DATA_MAP
}

// ----------------------------------------------------------------------------
void CPropDlgPath::Load(ChalkPath* pData)
{
	if (!pData)
		return;
	m_Speed = pData->m_Speed;
	m_NumPoints = pData->m_Data.size();
	m_SpriteDefn = pData->m_ObjDefn;
	m_SpriteName = _T("");
	m_PathType = pData->m_Type;
}

// ----------------------------------------------------------------------------
void CPropDlgPath::Save(ChalkPath* pData)
{
	if (!pData)
		return;
	pData->m_Speed = m_Speed;
	pData->m_ObjDefn = m_SpriteDefn;
	pData->m_Type = m_PathType;
}


// ----------------------------------------------------------------------------
BOOL CPropDlgPath::OnApply() 
{
	if (m_Dad)
		m_Dad->OnApply();
	return CPropertyPage::OnApply();
}

// ----------------------------------------------------------------------------
void CPropDlgPath::OnOK() 
{
	if (m_Dad)
		m_Dad->OnOK();
	CPropertyPage::OnOK();
}
