// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropDlgPoint.cpp
// CREATED:  11 Jul 2000 by Carl Muller
// MODIFIED: 11 Jul 2000 by Carl Muller
//
// This implements the property page for a point in a path
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalk.h"
#include "chalkDoc.h"
#include "chalkView.h"
#include "PropSheetBase.h"
#include "PropDlgPoint.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ----------------------------------------------------------------------------
// CPropDlgPoint property page
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
IMPLEMENT_DYNCREATE(CPropDlgPoint, CPropertyPage)

// ----------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CPropDlgPoint, CPropertyPage)
	//{{AFX_MSG_MAP(CPropDlgPoint)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// ----------------------------------------------------------------------------
CPropDlgPoint::CPropDlgPoint() : CPropertyPage(CPropDlgPoint::IDD)
{
	m_Dad = NULL;

	//{{AFX_DATA_INIT(CPropDlgPoint)
	m_PointIndex = _T("");
	m_PositionX = 0;
	m_PositionY = 0;
	m_PositionZ = 0;
	//}}AFX_DATA_INIT
}

// ----------------------------------------------------------------------------
CPropDlgPoint::~CPropDlgPoint()
{
}

// ----------------------------------------------------------------------------
void CPropDlgPoint::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropDlgPoint)
	DDX_Text(pDX, IDC_POINT_INDEX, m_PointIndex);
	DDX_Text(pDX, IDC_POSITION_X, m_PositionX);
	DDX_Text(pDX, IDC_POSITION_Y, m_PositionY);
	DDX_Text(pDX, IDC_POSITION_Z, m_PositionZ);
	//}}AFX_DATA_MAP
}

// ----------------------------------------------------------------------------
void CPropDlgPoint::Load(ChalkPoint* pData)
{
	if (!pData)
		return;
	m_PointIndex.Empty();
	m_PositionX = pData->m_Xpos;
	m_PositionY = pData->m_Ypos;
	m_PositionZ = pData->m_Zpos;
}

// ----------------------------------------------------------------------------
void CPropDlgPoint::Save(ChalkPoint* pData)
{
	if (!pData)
		return;
	pData->m_Xpos = m_PositionX;
	pData->m_Ypos = m_PositionY;
	pData->m_Zpos = m_PositionZ;
}

// ----------------------------------------------------------------------------
void CPropDlgPoint::OnOK() 
{
	if (m_Dad)
		m_Dad->OnOK();
	CPropertyPage::OnOK();
}

// ----------------------------------------------------------------------------
BOOL CPropDlgPoint::OnApply() 
{
	if (m_Dad)
		m_Dad->OnApply();
	return CPropertyPage::OnApply();
}
