// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropDlgSprite.cpp
// CREATED:   4 Jul 2000 by Carl Muller
// MODIFIED:  4 Jul 2000 by Carl Muller
//
// This implements the property page for sprites
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalk.h"
#include "chalkDoc.h"
#include "chalkView.h"
#include "PropSheetBase.h"
#include "PropDlgSprite.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ----------------------------------------------------------------------------
// CPropDlgSprite property page
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
IMPLEMENT_DYNCREATE(CPropDlgSprite, CPropertyPage)


// ----------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CPropDlgSprite, CPropertyPage)
	//{{AFX_MSG_MAP(CPropDlgSprite)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// ----------------------------------------------------------------------------
CPropDlgSprite::CPropDlgSprite() : CPropertyPage(CPropDlgSprite::IDD)
{
	m_Dad = NULL;

	//{{AFX_DATA_INIT(CPropDlgSprite)
	m_NameAttribute = _T("");
	m_NameDefn = _T("");
	m_PositionX = 0;
	m_PositionZ = 0;
	m_SpecialFlipX = FALSE;
	m_SpecialFlipY = FALSE;
	m_SpecialPriority = FALSE;
	m_SpriteIndex = _T("");
	m_ValueAttribute = 0;
	m_ValueDefn = 0;
	m_ValuePalette = 0;
	m_PositionY = 0;
	//}}AFX_DATA_INIT
}

// ----------------------------------------------------------------------------
CPropDlgSprite::~CPropDlgSprite()
{
}

// ----------------------------------------------------------------------------
void CPropDlgSprite::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropDlgSprite)
	DDX_Text(pDX, IDC_NAME_ATTRIBUTE, m_NameAttribute);
	DDX_Text(pDX, IDC_NAME_DEFN, m_NameDefn);
	DDX_Text(pDX, IDC_POSITION_X, m_PositionX);
	DDX_Text(pDX, IDC_POSITION_Z, m_PositionZ);
	DDX_Check(pDX, IDC_SPECIAL_FLIPX, m_SpecialFlipX);
	DDX_Check(pDX, IDC_SPECIAL_FLIPY, m_SpecialFlipY);
	DDX_Check(pDX, IDC_SPECIAL_PRIORITY, m_SpecialPriority);
	DDX_Text(pDX, IDC_SPRITE_INDEX, m_SpriteIndex);
	DDX_Text(pDX, IDC_VALUE_ATTRIBUTE, m_ValueAttribute);
	DDX_Text(pDX, IDC_VALUE_DEFN, m_ValueDefn);
	DDV_MinMaxInt(pDX, m_ValueDefn, 0, 999999);
	DDX_Text(pDX, IDC_VALUE_PALETTE, m_ValuePalette);
	DDV_MinMaxInt(pDX, m_ValuePalette, 0, 255);
	DDX_Text(pDX, IDC_POSITION_Y, m_PositionY);
	//}}AFX_DATA_MAP
}

// ----------------------------------------------------------------------------
void CPropDlgSprite::Load(ChalkSprite* pData)
{
	if (!pData)
		return;
	m_PositionX = pData->m_Xpos;
	m_PositionY = pData->m_Ypos;
	m_PositionZ = pData->m_Zpos;
	m_SpecialFlipX = pData->m_Special & SPECIAL_XFLIP ? TRUE : FALSE;
	m_SpecialFlipY = pData->m_Special & SPECIAL_YFLIP ? TRUE : FALSE;
	m_SpecialPriority = pData->m_Special & SPECIAL_PRIORITY ? TRUE : FALSE;
	m_SpriteIndex.Empty();
	m_NameAttribute.Empty();
	m_NameDefn.Empty();
	m_ValueAttribute = pData->m_Attribute;
	m_ValueDefn = pData->m_ObjDefn;
	m_ValuePalette = pData->m_PaletteOffset;
}

// ----------------------------------------------------------------------------
void CPropDlgSprite::Save(ChalkSprite* pData)
{
	pData->m_Xpos = m_PositionX;
	pData->m_Ypos = m_PositionY;
	pData->m_Zpos = m_PositionZ;
	pData->m_Special = SPECIAL_TRANSPARENT | 
		(m_SpecialFlipX ? SPECIAL_XFLIP : 0) |
		(m_SpecialFlipY ? SPECIAL_YFLIP : 0) |
		(m_SpecialPriority ? SPECIAL_PRIORITY : 0);
	pData->m_Attribute = m_ValueAttribute;
	pData->m_ObjDefn = m_ValueDefn;
	pData->m_PaletteOffset = m_ValuePalette;
}

// ----------------------------------------------------------------------------
BOOL CPropDlgSprite::OnApply() 
{
	if (m_Dad)
		m_Dad->OnApply();
	return CPropertyPage::OnApply();
}

// ----------------------------------------------------------------------------
void CPropDlgSprite::OnOK() 
{
	if (m_Dad)
		m_Dad->OnOK();
	CPropertyPage::OnOK();
}

