// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropSheetBase.h
// CREATED:   3 Jul 2000 by Carl Muller
// MODIFIED: 11 Jul 2000 by Carl Muller
//
// This defines the property page for all game objects
// ----------------------------------------------------------------------------

class CPropDlgGeneral;
class CPropDlgComment;
class CPropDlgPalette;
class CPropDlgBitmap;
class CPropDlgMapBlock;
class CPropDlgMap;
class CPropDlgSprite;
class CPropDlgBox;
class CPropDlgPoint;
class CPropDlgPath;
class CPropDlgFrame;
class CPropDlgAnimation;

// ----------------------------------------------------------------------------
// Base class for property sheets, used by individual property pages
class CPropertySheetBase : public CPropertySheet
{
public:
	CPropertySheetBase(LPCTSTR pszTitle) : CPropertySheet(pszTitle) {}
	~CPropertySheetBase() {}
	virtual void OnApply() = 0; // User pressed "Apply" while child page was active
	virtual void OnOK() = 0; // User pressed "OK" while child page was active
};

// ----------------------------------------------------------------------------
// Property sheet for a palette (e.g. a palette bar layer such as a .COP file)
class CPropertySheetPalette : public CPropertySheetBase
{
	public:
		CPropertySheetPalette(class ChalkPalette *data,
			CDocument *doc, CWnd* pParent = NULL);   // standard constructor
		~CPropertySheetPalette();
		void OnApply();
		void OnOK();

		CPropDlgGeneral *page1;
		CPropDlgComment *page2;
		CPropDlgPalette *page3;

		CDocument *m_pDoc;
		ChalkPalette *m_pData;
};

// ----------------------------------------------------------------------------
// Property sheet for a bitmap layer (e.g. a .LBM file)
class CPropertySheetBitmap : public CPropertySheetBase
{
	public:
		CPropertySheetBitmap(class ChalkLayerBitmap *data,
			CDocument *doc, CWnd* pParent = NULL);   // standard constructor
		~CPropertySheetBitmap();
		void OnApply();
		void OnOK();

		CPropDlgGeneral *page1;
		CPropDlgComment *page2;
		CPropDlgPalette *page3;
		CPropDlgBitmap *page4;

		CDocument *m_pDoc;
		ChalkLayerBitmap *m_pData;
};

// ----------------------------------------------------------------------------
// Property sheet for a single block within a map
class CPropertySheetMapBlock : public CPropertySheetBase
{
	public:
		CPropertySheetMapBlock(class ChalkMapBlock *data,
			CDocument *doc, CWnd* pParent = NULL);   // standard constructor
		~CPropertySheetMapBlock();
		void OnApply();
		void OnOK();

		CPropDlgMapBlock *page1;

		CDocument *m_pDoc;
		ChalkMapBlock *m_pData;
};

// ----------------------------------------------------------------------------
// Property sheet for a map
class CPropertySheetMap : public CPropertySheetBase
{
	public:
		CPropertySheetMap(class ChalkLayerMap *data,
			CDocument *doc, CWnd* pParent = NULL);   // standard constructor
		~CPropertySheetMap();
		void OnApply();
		void OnOK();

		CPropDlgGeneral *page1;
		CPropDlgComment *page2;
		CPropDlgMap *page3;

		CDocument *m_pDoc;
		ChalkLayerMap *m_pData;
};

// ----------------------------------------------------------------------------
// Property sheet for a single sprite position (e.g. within a .FRK file)
class CPropertySheetSprite : public CPropertySheetBase
{
	public:
		CPropertySheetSprite(class ChalkSprite *data,
			CDocument *doc, CWnd* pParent = NULL);   // standard constructor
		~CPropertySheetSprite();
		void OnApply();
		void OnOK();

		CPropDlgGeneral *page1;
		CPropDlgComment *page2;
		CPropDlgSprite *page3;

		CDocument *m_pDoc;
		ChalkSprite *m_pData;
};

// ----------------------------------------------------------------------------
// Property sheet for a single box (e.g. within a .FRK or .BOX file)
class CPropertySheetBox : public CPropertySheetBase
{
	public:
		CPropertySheetBox(class ChalkBox *data,
			CDocument *doc, CWnd* pParent = NULL);   // standard constructor
		~CPropertySheetBox();
		void OnApply();
		void OnOK();

		CPropDlgGeneral *page1;
		CPropDlgComment *page2;
		CPropDlgBox *page3;

		CDocument *m_pDoc;
		ChalkBox *m_pData;
};


// ----------------------------------------------------------------------------
// Property sheet for a single point within a path
class CPropertySheetPoint : public CPropertySheetBase
{
	public:
		CPropertySheetPoint(class ChalkPoint *data,
			CDocument *doc, CWnd* pParent = NULL);   // standard constructor
		~CPropertySheetPoint();
		void OnApply();
		void OnOK();

		CPropDlgGeneral *page1;
		CPropDlgComment *page2;
		CPropDlgPoint *page3;

		CDocument *m_pDoc;
		ChalkPoint *m_pData;
};

// ----------------------------------------------------------------------------
// Property sheet for a path
class CPropertySheetPath : public CPropertySheetBase
{
	public:
		CPropertySheetPath(class ChalkPath *data,
			CDocument *doc, CWnd* pParent = NULL);   // standard constructor
		~CPropertySheetPath();
		void OnApply();
		void OnOK();

		CPropDlgGeneral *page1;
		CPropDlgComment *page2;
		CPropDlgPath *page3;

		CDocument *m_pDoc;
		ChalkPath *m_pData;
};

// ----------------------------------------------------------------------------
// Property sheet for a frame within an animation layer (e.g. a frame of a .FRK file)
class CPropertySheetFrame : public CPropertySheetBase
{
	public:
		CPropertySheetFrame(class ChalkAnimation *data,
			CDocument *doc, int* pcurrentframe, CWnd* pParent = NULL);   // standard constructor
		~CPropertySheetFrame();
		void OnApply();
		void OnOK();

		CPropDlgGeneral *page1;
		CPropDlgComment *page2;
		CPropDlgFrame *page3;

		CDocument *m_pDoc;
		ChalkAnimation *m_pData;
		int *m_pCurrentFrame;
};

// ----------------------------------------------------------------------------
// Property sheet for an animation layer (e.g. a .FRK or .BOX file)
class CPropertySheetAnimation : public CPropertySheetBase
{
	public:
		CPropertySheetAnimation(class ChalkLayerAnimation *data,
			CDocument *doc, CWnd* pParent = NULL);   // standard constructor
		~CPropertySheetAnimation();
		void OnApply();
		void OnOK();

		CPropDlgGeneral *page1;
		CPropDlgComment *page2;
		CPropDlgAnimation *page3;

		CDocument *m_pDoc;
		ChalkLayerAnimation *m_pData;
};
