// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     PropSheetFrame.cpp
// CREATED:   5 Jul 2000 by Carl Muller
// MODIFIED:  5 Apr 2001 by Carl Muller
//
// This defines the property page for an animation frame
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalk.h"
#include "chalkDoc.h"
#include "chalkView.h"
#include "PropSheetBase.h"
#include "PropDlgGeneral.h"
#include "PropDlgComment.h"
#include "PropDlgFrame.h"

// ----------------------------------------------------------------------------
// CPropertySheetFrame
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// Create the property sheet
CPropertySheetFrame::CPropertySheetFrame(ChalkAnimation *data,
	CDocument *doc, 
	int* pcurrentframe,
	CWnd* pParent /*=NULL*/)
	: CPropertySheetBase(_T("Frame Properties"))
{
	page1 = NULL;
	page2 = NULL;
	page3 = NULL;
	m_pDoc = doc;
	m_pData = data;
	m_pCurrentFrame = pcurrentframe;
	ChalkFrame* pFrame = &m_pData->m_Frames[*m_pCurrentFrame];

	page1 = new CPropDlgGeneral();
	page1->m_Dad = this;
	page1->Load(pFrame);

	page2 = new CPropDlgComment();
	page2->m_Dad = this;
	page2->Load(pFrame);

	page3 = new CPropDlgFrame();
	page3->m_Dad = this;
	page3->Load(m_pData, *pcurrentframe);

	AddPage(page3);
	AddPage(page2);
	AddPage(page1);
}


// ----------------------------------------------------------------------------
// Destroy the property sheet
CPropertySheetFrame::~CPropertySheetFrame()
{
	delete page3;
	delete page2;
	delete page1;
}

// ----------------------------------------------------------------------------
// Handle the "Apply" button, which is passed up from one of my child pages
void CPropertySheetFrame::OnApply() 
{
	OnOK();
}

// ----------------------------------------------------------------------------
// Handle the "OK" button, which is passed up from one of my child pages
void CPropertySheetFrame::OnOK() 
{
	// Remember undo information
	// ...

	// Change the appropriate data
	page3->Save(m_pData, m_pCurrentFrame);
	ChalkFrame* pFrame = &m_pData->m_Frames[*m_pCurrentFrame];
	page1->Save(pFrame);
	page2->Save(pFrame);

	// Signal that the data has changed
	m_pDoc->SetModifiedFlag();
	m_pDoc->UpdateAllViews(NULL);
}
