// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     UndoBuffer.h
// CREATED:   3 Oct 2001 by Carl Muller
// MODIFIED: 16 Oct 2001 by Carl Muller
//
// This file defines a class that implements an Undo buffer
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
class UndoBuffer : public MemoryBuffer
{
	// Create some more room by writing a full undo block
	virtual void MakeRoom()
	{
		int blocksize = ReadLong(); // size value at beginning of block
		while (blocksize--) // Ignore the block
		{
			ReadByte();
		}
		ReadLong(); // size value at end of block
	}
};
