// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     Chalk.cpp
// CREATED:  28 Apr 2000 by Carl Muller
// MODIFIED: 16 Jul 2000 by Carl Muller
//
// Defines the class behaviors for the application.
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalk.h"

#include "MainFrm.h"
#include "ChildFrm.h"
#include "chalkDoc.h"
#include "chalkView.h"

#include "DlgAbout.h"
#include "DlgNewBitmap.h"
#include "DlgNewMap.h"
#include "DlgNewAnimation.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ----------------------------------------------------------------------------
// Application
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// The one and only CChalkApp object
CChalkApp theApp;

// ----------------------------------------------------------------------------
// CChalkApp
BEGIN_MESSAGE_MAP(CChalkApp, CWinApp)
	//{{AFX_MSG_MAP(CChalkApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_UPDATE_COMMAND_UI(ID_STATUS_FRAME, OnUpdateStatusFrame)
	ON_UPDATE_COMMAND_UI(ID_STATUS_LAYER, OnUpdateStatusLayer)
	ON_UPDATE_COMMAND_UI(ID_STATUS_POSITION, OnUpdateStatusPosition)
	ON_UPDATE_COMMAND_UI(ID_STATUS_TYPE, OnUpdateStatusType)
	ON_COMMAND(ID_FILE_NEWPALETTE, OnFileNewpalette)
	ON_COMMAND(ID_FILE_NEWBITMAP, OnFileNewbitmap)
	ON_COMMAND(ID_FILE_NEWMAP, OnFileNewmap)
	ON_COMMAND(ID_FILE_NEWOBJECTMAP, OnFileNewobjectmap)
	ON_UPDATE_COMMAND_UI(ID_FILE_NEWOBJECTMAP, OnUpdateFileNewobjectmap)
	ON_UPDATE_COMMAND_UI(ID_FILE_NEWMAP, OnUpdateFileNewmap)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()


// ----------------------------------------------------------------------------
// CChalkApp construction
CChalkApp::CChalkApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}


// ----------------------------------------------------------------------------
// CChalkApp initialization
BOOL CChalkApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_CHALKTYPE,
		RUNTIME_CLASS(CChalkDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CChalkView));
	AddDocTemplate(pDocTemplate);

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	cmdInfo.m_nShellCommand = CCommandLineInfo::FileNothing; // Do not create a new file by default
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->DockToolBars();
	pMainFrame->UpdateWindow();

	return TRUE;
}

// ----------------------------------------------------------------------------
// App command to run the dialog
void CChalkApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

// ----------------------------------------------------------------------------
void CChalkApp::OnUpdateStatusFrame(CCmdUI* pCmdUI) 
{
	pCmdUI->SetText(FORMAT_SPACE);
}

// ----------------------------------------------------------------------------
void CChalkApp::OnUpdateStatusLayer(CCmdUI* pCmdUI) 
{
	pCmdUI->SetText(FORMAT_SPACE);
}

// ----------------------------------------------------------------------------
void CChalkApp::OnUpdateStatusPosition(CCmdUI* pCmdUI) 
{
	pCmdUI->SetText(FORMAT_SPACE);
}

// ----------------------------------------------------------------------------
void CChalkApp::OnUpdateStatusType(CCmdUI* pCmdUI) 
{
	pCmdUI->SetText(FORMAT_SPACE);
}

// ----------------------------------------------------------------------------
// Create a new file that contains a palette layer
CChalkDoc *CChalkApp::OnFileNewEmpty() 
{
	POSITION posn = GetFirstDocTemplatePosition();
	if (posn)
	{
		CDocTemplate* pTemplate = GetNextDocTemplate(posn);
		if (pTemplate)
		{
			CChalkDoc *pDoc = static_cast<CChalkDoc*>(pTemplate->OpenDocumentFile(NULL));
			if (pDoc)
			{
				return pDoc;
			}
		}
	}
	return NULL;
}


// ----------------------------------------------------------------------------
// Create a new file that contains a palette layer
void CChalkApp::OnFileNewpalette() 
{
	CChalkDoc *pDoc = OnFileNewEmpty();
	if (pDoc)
	{
		// Add a palette layer
		ChalkLayerPaletteBars* pLayer;
		pLayer = new ChalkLayerPaletteBars(*pDoc);
		pDoc->m_Layers.push_back(pLayer);
		pLayer->m_Data.SetFalseColour();
		pDoc->SelectLayer(pLayer);
		pDoc->CalcSize();
	}
}

// ----------------------------------------------------------------------------
// Create a new file that contains a bitmap layer (e.g. BMP/LBM)
void CChalkApp::OnFileNewbitmap() 
{
	// Get input parameters
	CDlgNewBitmap dlg;
	int width, height, numplanes;

	if (IDOK == dlg.DoModal())
	{
		const int PlanesLookup[] = { 1, 2, 4, 8, 16, 32 };

		// Get parameters
		width = dlg.m_Width;
		height = dlg.m_Height;
		numplanes = PlanesLookup[dlg.m_Depth];

		// Create the new bitmap
		CChalkDoc *pDoc = OnFileNewEmpty();
		if (pDoc)
		{
			// Add a bitmap layer
			ChalkLayerBitmap* pLayer;
			pLayer = new ChalkLayerBitmap(*pDoc);
			pDoc->m_Layers.push_back(pLayer);
			pLayer->m_Data.m_Palette.SetFalseColour();
			pLayer->m_Data.m_Character.SetSize(width, height, numplanes);
			pDoc->SelectLayer(pLayer);
			pDoc->CalcSize();
		}
	}
}


// ----------------------------------------------------------------------------
// Create a new file that contains a map layer (e.g. MAP)
void CChalkApp::OnFileNewmap()
{
	// Get input parameters
	CDlgNewMap dlg;
	int width, height, matrixx = 2, matrixy = 2;
	CFileName blockname, attfontname;

	if (IDOK == dlg.DoModal())
	{
		// Get parameters
		width = dlg.m_Width;
		height = dlg.m_Height;
		blockname.Set(static_cast<LPCTSTR>(dlg.m_BlocksFile));
		attfontname.Set(static_cast<LPCTSTR>(dlg.m_AttrFile));

		// Create the new bitmap
		CChalkDoc *pDoc = OnFileNewEmpty();
		if (pDoc)
		{
			// Add a map layer
			ChalkLayerMap* pLayer;
			pLayer = new ChalkLayerMap(*pDoc);
			pDoc->m_Layers.push_back(pLayer);
			pLayer->m_Data.LoadBlocks(blockname, attfontname, matrixx, matrixy);

			// Add an animation frame to it
			pLayer->m_Data.m_Data.resize(1);
			ChalkMap& map = pLayer->m_Data.m_Data[0];
			map.SetSize(width, height);
//...
			pDoc->SelectLayer(pLayer);
			pDoc->CalcSize();
		}
	}
}

// ----------------------------------------------------------------------------
// Create a new file that contains an object map layer (e.g. FRK)
void CChalkApp::OnFileNewobjectmap() 
{
	// Get input parameters
	CDlgNewAnimation dlg;
	CFileName backdropname, spritename;

	if (IDOK == dlg.DoModal())
	{
		// Get parameters
		backdropname.Set(static_cast<LPCTSTR>(dlg.m_Backdrop));
		spritename.Set(static_cast<LPCTSTR>(dlg.m_Sprites));

		// Create the new object map
		CChalkDoc *pDoc = OnFileNewEmpty();
		if (pDoc)
		{
			pDoc->Clear();
			pDoc->AddLayer(backdropname);

			// Add an object map layer
			ChalkLayerAnimation * pLayer;
			pLayer = new ChalkLayerAnimation(*pDoc);
			pDoc->m_Layers.insert(pDoc->m_Layers.begin(), pLayer);
			pLayer->m_Data.m_KidName = backdropname;
			pLayer->m_Data.m_DefnNames.push_back(spritename);
			pLayer->m_Data.LoadBlocks();
			pLayer->m_Data.m_Frames.resize(1);
			pDoc->ChangeFrame();

			// Add background layer (in case nothing else is visible)
			ChalkLayer* pBackground;
			pBackground = new ChalkLayer(*pDoc);
			pDoc->m_Layers.insert(pDoc->m_Layers.begin(), pBackground);
			pBackground->m_Visible = layer_hidden;

			pDoc->SelectLayer(pLayer);
			pDoc->CalcSize();
		}
	}
}

void CChalkApp::OnUpdateFileNewobjectmap(CCmdUI* pCmdUI) 
{
	// The command is not working properly yet - so disable it
	pCmdUI->Enable(FALSE);
}

void CChalkApp::OnUpdateFileNewmap(CCmdUI* pCmdUI) 
{
	// The command is not working properly yet - so disable it
	pCmdUI->Enable(FALSE);
}
