// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     Chalk.h
// CREATED:  28 Apr 2000 by Carl Muller
// MODIFIED: 26 Mar 2001 by Carl Muller
//
// Main header file for the CHALK application
//
// ----------------------------------------------------------------------------
// Naming conventions for the CHALK project
//
// Constants
// ---------
//     UPPER_CASE
//
// Typedefs of primitives
// ----------------------
//     UPPERCASE
//
// Classes
// -------
// Prefix:
//     C
// Name:
//     MixedCase
// 
//
// Variables
// ---------
// Scope:
//     m_* = member variable 
//     s_* = static class variable
//     g_* = global variable
// Indirection:
//     h = handle (opaque pointer)
//     p = pointer
//     pp = pointer to pointer (transparent handle)
// Type:
//     Microsoft Hungarian, but only in Microsoft API calls.
// Name:
//     MixedCase for member, static and global variables
//     lowercase for parameters and local variables
// ----------------------------------------------------------------------------

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols

class CChalkDoc;

// ----------------------------------------------------------------------------
// CChalkApp:
class CChalkApp : public CWinApp
{
public:
	CChalkApp();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CChalkApp)
	public:
	virtual BOOL InitInstance();
	//}}AFX_VIRTUAL

// Implementation
	CChalkDoc *OnFileNewEmpty(); // Create a new empty file

	//{{AFX_MSG(CChalkApp)
	afx_msg void OnAppAbout();
	afx_msg void OnUpdateStatusFrame(CCmdUI* pCmdUI);
	afx_msg void OnUpdateStatusLayer(CCmdUI* pCmdUI);
	afx_msg void OnUpdateStatusPosition(CCmdUI* pCmdUI);
	afx_msg void OnUpdateStatusType(CCmdUI* pCmdUI);
	afx_msg void OnFileNewpalette();
	afx_msg void OnFileNewbitmap();
	afx_msg void OnFileNewmap();
	afx_msg void OnFileNewobjectmap();
	afx_msg void OnUpdateFileNewobjectmap(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileNewmap(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

extern CChalkApp theApp;
