// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     ChalkDoc.h
// CREATED:  28 Apr 2000 by Carl Muller
// MODIFIED: 16 Oct 2001 by Carl Muller
//
// Interface of the CChalkDoc class
// ----------------------------------------------------------------------------

#include "chalklayer.h"



// ----------------------------------------------------------------------------
class CChalkDoc : public CDocument
{
protected: // create from serialization only
	CChalkDoc();
	DECLARE_DYNCREATE(CChalkDoc)

// Attributes
public:
	// Layers loaded up
	vector<ChalkLayer*> m_Layers;
	ChalkDocument m_Document; // For undo buffers
	CSize m_DocSize; // Extent of the layers
	tstring m_StatusType;
	tstring m_StatusLayer;
	tstring m_StatusFrame;
	tstring m_StatusPosition;
	tstring m_StatusZoom;

// Operations
public:
	void Clear();
	void AddLayer(const CFileName& filename);
	void CalcSize();
	void SelectLayer(ChalkLayer *which);
	// Called by layer GUI
	void InvalidateViewsAll(); // All views are invalid (e.g. frame has changed)
	void InvalidateViewsRect(CRect rect, CRect border); // This rectangle is invalid in all views
	void ChangeFrame();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CChalkDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CChalkDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

private:

// Generated message map functions
protected:
	//{{AFX_MSG(CChalkDoc)
	afx_msg void OnUpdateStatusLayer(CCmdUI* pCmdUI);
	afx_msg void OnUpdateStatusPosition(CCmdUI* pCmdUI);
	afx_msg void OnUpdateStatusType(CCmdUI* pCmdUI);
	afx_msg void OnUpdateStatusFrame(CCmdUI* pCmdUI);
	afx_msg void OnUpdateStatusZoom(CCmdUI* pCmdUI);
	afx_msg void OnAnimNext();
	afx_msg void OnAnimRewind();
	afx_msg void OnAnimPrevious();
	afx_msg void OnAnimFfwd();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

