// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     ChalkView.h
// CREATED:  28 Apr 2000 by Carl Muller
// MODIFIED: 16 Jul 2000 by Carl Muller
//
// Interface of the CChalkView class
// ----------------------------------------------------------------------------

typedef enum {
	autoscroll_none  = 0,
	autoscroll_left  = 1,
	autoscroll_right = 2,
	autoscroll_up    = 4,
	autoscroll_down  = 8,
} autoscroll;


// ----------------------------------------------------------------------------
class CChalkView : public CScrollView
{
protected: // create from serialization only
	CChalkView();
	DECLARE_DYNCREATE(CChalkView)

// Attributes
public:
	CChalkDoc* GetDocument();
	ChalkLayer* GetActiveLayer(); // Can return NULL
	ChalkDisplay m_Display;

	// Handle autoscroll
	UINT m_Timer; // Timer ID
	autoscroll m_AutoScroll; // Assist with automatic scrolling (on timer)
	CPoint m_LastMouseMove;
	UINT m_LastMouseFlags;
	bool m_LastMouseLeft;

// Operations
public:
	CPoint ScalePoint(CPoint point);
	void AutoScroll(CPoint pt);
	void UpdateDrawMode(CCmdUI* pCmdUI, DrawMode drawmode);
	void SetDrawMode(DrawMode drawmode);
	void UpdateDrawAttribute(CCmdUI* pCmdUI, DrawAttributes drawattr);
	void ToggleDrawAttribute(DrawAttributes drawattr);
	void UpdateDrawCommand(CCmdUI* pCmdUI, DrawCommands drawcmd);
	void PerformDrawCommand(DrawCommands drawcmd);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CChalkView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CChalkView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CChalkView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnUpdateDrawSelect(CCmdUI* pCmdUI);
	afx_msg void OnDrawSelect();
	afx_msg void OnUpdateDrawDraw(CCmdUI* pCmdUI);
	afx_msg void OnDrawDraw();
	afx_msg void OnUpdateDrawRectangle(CCmdUI* pCmdUI);
	afx_msg void OnDrawRectangle();
	afx_msg void OnUpdateDrawSprite(CCmdUI* pCmdUI);
	afx_msg void OnDrawSprite();
	afx_msg void OnUpdateDrawBox(CCmdUI* pCmdUI);
	afx_msg void OnDrawBox();
	afx_msg void OnUpdateDrawOffsets(CCmdUI* pCmdUI);
	afx_msg void OnDrawOffsets();
	afx_msg void OnUpdateDrawPath(CCmdUI* pCmdUI);
	afx_msg void OnDrawPath();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnUpdateDrawGrid(CCmdUI* pCmdUI);
	afx_msg void OnDrawGrid();
	afx_msg void OnDrawText();
	afx_msg void OnUpdateDrawText(CCmdUI* pCmdUI);
	afx_msg void OnDrawAttributes();
	afx_msg void OnUpdateDrawAttributes(CCmdUI* pCmdUI);
	afx_msg void OnEditProperties();
	afx_msg void OnRButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLayerProperties();
	afx_msg void OnDrawReplaceall();
	afx_msg void OnUpdateDrawReplaceall(CCmdUI* pCmdUI);
	afx_msg void OnDrawLasso();
	afx_msg void OnUpdateDrawLasso(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFrameProperties(CCmdUI* pCmdUI);
	afx_msg void OnFrameProperties();
	afx_msg void OnUpdateEditProperties(CCmdUI* pCmdUI);
	afx_msg void OnBrushDecrement();
	afx_msg void OnUpdateBrushDecrement(CCmdUI* pCmdUI);
	afx_msg void OnBrushIncrement();
	afx_msg void OnUpdateBrushIncrement(CCmdUI* pCmdUI);
	afx_msg void OnBrushFlipx();
	afx_msg void OnUpdateBrushFlipx(CCmdUI* pCmdUI);
	afx_msg void OnBrushFlipy();
	afx_msg void OnUpdateBrushFlipy(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditMove(CCmdUI* pCmdUI);
	afx_msg void OnEditMove();
	afx_msg void OnEditPurge();
	afx_msg void OnUpdateEditPurge(CCmdUI* pCmdUI);
	afx_msg void OnEditSort();
	afx_msg void OnUpdateEditSort(CCmdUI* pCmdUI);
	afx_msg void OnEditAlign();
	afx_msg void OnUpdateEditAlign(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLayerProperties(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditCut(CCmdUI* pCmdUI);
	afx_msg void OnEditCut();
	afx_msg void OnEditCopy();
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditPaste(CCmdUI* pCmdUI);
	afx_msg void OnEditPaste();
	afx_msg void OnUpdateEditDelete(CCmdUI* pCmdUI);
	afx_msg void OnEditDelete();
	afx_msg void OnUpdateEditSelectAll(CCmdUI* pCmdUI);
	afx_msg void OnEditSelectAll();
	afx_msg void OnFrameDelete();
	afx_msg void OnUpdateFrameDelete(CCmdUI* pCmdUI);
	afx_msg void OnFrameInsert();
	afx_msg void OnUpdateFrameInsert(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileTopalette(CCmdUI* pCmdUI);
	afx_msg void OnFileTopalette();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	void OnZoom100(void);
	void OnZoom200(void);
	void OnZoom400(void);
	void OnZoom800(void);
	void OnZoom50(void);
	void OnZoom25(void);
	void OnZoom12(void);

private:
	void SetZoom(int zoommult, int zoomdiv);
	bool m_IsPrinting; // Used to override behaviour when printing
	int m_OldZoomMult;
	int m_OldZoomDiv;
};

#ifndef _DEBUG  // debug version in chalkView.cpp
inline CChalkDoc* CChalkView::GetDocument()
   { return static_cast<CChalkDoc*>(m_pDocument); }
#endif

