// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     ChalkLayer.cpp
// CREATED:  28 Apr 2000 by Carl Muller
// MODIFIED: 16 Oct 2001 by Carl Muller
//
// Implements visible objects
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalkDoc.h"
#include "chalkView.h"

// ----------------------------------------------------------------------------
// ChalkLayer
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
ChalkLayer::ChalkLayer(CChalkDoc& Doc) :
	m_Doc(Doc),
	m_Document(Doc.m_Document)
{
	m_TypeName = _T("Default");
	m_pBaseData = NULL;
	m_Solid = true;
	m_DrawModesSupported = drawmode_select; // What actions can this type of layer take?
	m_DrawMode = drawmode_select;
	m_DrawAttributes = drawattr_none;
	m_DrawAttributesSupported = drawattr_none; // What modes do I support?
	m_DrawCommandsSupported = drawcmd_none; // No commands supported
	m_RelativeX = 1.0;
	m_RelativeY = 1.0;
	m_Visible = layer_visible;
	m_OffsetX = 0;
	m_OffsetY = 0;
	m_CurrentFrame = 0;
}

// ----------------------------------------------------------------------------
ChalkLayer::~ChalkLayer()
{
}

// ----------------------------------------------------------------------------
// Default layer drawing
// Always draw into the top-left of the bitmap
// The rectangle is given in logical co-ordinates
void ChalkLayer::Draw(ChalkDisplay& display, CRect rt)
{
	int bitmapwidth = display.GetBitmapSize().cx;
	PIXEL *pRow = display.m_pBits;

	// Clear the bitmap to multicoloured value
	for (int y = rt.top; y < rt.bottom; ++y)
	{
		PIXEL value = ((y & 255) << 16) + rt.left;
		PIXEL *pPixel = pRow;
		int n = rt.right - rt.left;
		if (n > 0)
			while (n--)
				*pPixel++ = value++; // Multicolour spread
		pRow += bitmapwidth;
	}
}

// ----------------------------------------------------------------------------
CSize ChalkLayer::GetSize()
{
	return CSize(0,0);
}

// ----------------------------------------------------------------------------
// Returns pointer to my palette object
ChalkPalette* ChalkLayer::GetPalette()
{
	return NULL;
}

// ----------------------------------------------------------------------------
// Get number of animation frames in this layer
int ChalkLayer::GetNumFrames()
{
	return 1;
}

// ----------------------------------------------------------------------------
// Returns the main selected object
ChalkObject* ChalkLayer::GetSelectedObject()
{
	return NULL;
}

// ----------------------------------------------------------------------------
bool ChalkLayer::OnLButtonDblClk(CChalkView* /* pView */, UINT /* nFlags */, CPoint /* point */)
{
	return false;
}

// ----------------------------------------------------------------------------
bool ChalkLayer::OnRButtonDblClk(CChalkView* /* pView */, UINT /* nFlags */, CPoint /* point */)
{
	return false;
}

// ----------------------------------------------------------------------------
bool ChalkLayer::OnLButtonDown(CChalkView* /* pView */, UINT /* nFlags */, CPoint /* point */)
{
	return false;
}

// ----------------------------------------------------------------------------
bool ChalkLayer::OnRButtonDown(CChalkView* /* pView */, UINT /* nFlags */, CPoint /* point */)
{
	return false;
}

// ----------------------------------------------------------------------------
bool ChalkLayer::OnMouseMove(CChalkView* /* pView */, UINT /* nFlags */, CPoint /* point */)
{
	return false;
}

// ----------------------------------------------------------------------------
bool ChalkLayer::OnLButtonUp(CChalkView* /* pView */, UINT /* nFlags */, CPoint /* point */)
{
	return false;
}

// ----------------------------------------------------------------------------
bool ChalkLayer::OnRButtonUp(CChalkView* /* pView */, UINT /* nFlags */, CPoint /* point */)
{
	return false;
}

// ----------------------------------------------------------------------------
bool ChalkLayer::OnTimer(CChalkView* /* pView */, UINT /* nIDEvent */)
{
	return false;
}

// ----------------------------------------------------------------------------
bool ChalkLayer::OnChar(CChalkView* /* pView */, UINT /* nChar */, UINT /* nRepCnt */ )
{
	return false;
}

// ----------------------------------------------------------------------------
// Perform a drawing command
void ChalkLayer::EditCommand(DrawCommands /* cmd */)
{
}

// ----------------------------------------------------------------------------
// Helper functions
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
void ChalkLayer::SetSelectBox(CChalkView *pView, CRect rt)
{
	// Restore the pixels underneath the old selection box
	CRect ir = m_SelectionBox;
	float zoom = pView->m_Display.GetZoom();
	ir.left = zoom * ir.left;
	ir.top = zoom * ir.top;
	ir.right = zoom * ir.right;
	ir.bottom = zoom * ir.bottom;
	ir -= pView->GetDeviceScrollPosition();
	if ((ir.Width() > 16) && (ir.Height() > 16)) // Optimise redrawing for large areas
	{
		// Invalidate just the edges of the rectangle
		pView->InvalidateRect(CRect(ir.left, ir.top, ir.right, ir.top + 1));
		pView->InvalidateRect(CRect(ir.left, ir.top+1, ir.left + 1, ir.bottom - 1));
		pView->InvalidateRect(CRect(ir.right-1, ir.top+1, ir.right, ir.bottom - 1));
		pView->InvalidateRect(CRect(ir.left, ir.bottom-1, ir.right, ir.bottom));
	}
	else // Simple method
		pView->InvalidateRect(ir); // Hide the box on this screen

	// Set the position of the selection box
	m_SelectionBox = rt;

	// Signal to repaint the new selection box area
	ir = m_SelectionBox;
	ir.left = zoom * ir.left;
	ir.top = zoom * ir.top;
	ir.right = zoom * ir.right;
	ir.bottom = zoom * ir.bottom;
	ir -= pView->GetDeviceScrollPosition();
	if ((ir.Width() > 16) && (ir.Height() > 16)) // Optimise redrawing for large areas
	{
		// Invalidate just the edges of the rectangle
		pView->InvalidateRect(CRect(ir.left, ir.top, ir.right, ir.top + 1));
		pView->InvalidateRect(CRect(ir.left, ir.top+1, ir.left + 1, ir.bottom - 1));
		pView->InvalidateRect(CRect(ir.right-1, ir.top+1, ir.right, ir.bottom - 1));
		pView->InvalidateRect(CRect(ir.left, ir.bottom-1, ir.right, ir.bottom));
	}
	else // Simple method
		pView->InvalidateRect(ir); // Hide the box on this screen
}
