// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     Constants.cpp
// CREATED:  28 Apr 2000 by Carl Muller
// MODIFIED: 16 Jul 2000 by Carl Muller
//
// Define some constants
// ----------------------------------------------------------------------------

#include "stdafx.h"
#include "chalkobjects.h"

// Standard format specifiers
LPCTSTR FORMAT_EMPTY			= _T("");
LPCTSTR FORMAT_SPACE			= _T(" ");
LPCTSTR FORMAT_DECIMAL			= _T("%d");
LPCTSTR FORMAT_PERCENT			= _T("%d%%");
LPCTSTR FORMAT_HEX2				= _T("0x%02x");
LPCTSTR FORMAT_HEX4				= _T("0x%04x");
LPCTSTR FORMAT_HEX8				= _T("0x%08x");

// GUIDs for standard types
const GUID GUID_VOID	  = { 0x00000000, 0x0000, 0x0000, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }};
const GUID GUID_TYPE	  = { 0xdae52fc0, 0x1a3c, 0x11d4, { 0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_SYSTEM    = { 0x1655f780, 0x22d8, 0x11d4, { 0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_PALETTE	  = { 0xbd1cde60, 0x1a3d, 0x11d4, { 0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_CHARACTER = { 0x496a6540, 0x1bbf, 0x11d4, { 0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_BITMAP    = { 0x9d1835a0, 0x1bbf, 0x11d4, { 0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_FONT      = { 0x9bc15620, 0x1c99, 0x11d4, { 0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_BOX       = { 0xa703b8c0, 0x1c99, 0x11d4, { 0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_POINT     = { 0xb2f71be0, 0x1c99, 0x11d4, { 0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_PATH      = { 0xbdddf100, 0x1c99, 0x11d4, { 0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_SPRITE    = { 0xccdb86e0, 0x1c99, 0x11d4, { 0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_FRAME     = { 0xd417f1a0, 0x1c99, 0x11d4, { 0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_ANIMATION = { 0xda47ce60, 0x1c99, 0x11d4, { 0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_MAP       = { 0xe5ed19e0, 0x1efc, 0x11d4, { 0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};

// GUIDs for standard computer systems
const GUID GUID_SYSTEM_UNKNOWN    = { 0xd14d61a0, 0x22c8, 0x11d4, {0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_SYSTEM_C64        = { 0x21d88de0, 0x22cc, 0x11d4, {0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_SYSTEM_AMIGA      = { 0x22712460, 0x22cc, 0x11d4, {0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_SYSTEM_ATARIST    = { 0xabe6bb20, 0x22e4, 0x11d4, {0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_SYSTEM_SINCLAIRQL = { 0x22898e60, 0x22cc, 0x11d4, {0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_SYSTEM_GAMEGEAR   = { 0x22a37f00, 0x22cc, 0x11d4, {0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_SYSTEM_MASTER     = { 0x22bbe900, 0x22cc, 0x11d4, {0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_SYSTEM_MEGADRIVE  = { 0x30516360, 0x22cc, 0x11d4, {0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_SYSTEM_GAMEBOY    = { 0x30e9f9e0, 0x22cc, 0x11d4, {0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_SYSTEM_NES        = { 0x310263e0, 0x22cc, 0x11d4, {0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_SYSTEM_SNES       = { 0x311c5480, 0x22cc, 0x11d4, {0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_SYSTEM_SNESMODE7  = { 0x3134be80, 0x22cc, 0x11d4, {0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_SYSTEM_PC         = { 0x8112f700, 0x22d1, 0x11d4, {0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};
const GUID GUID_SYSTEM_TARGA      = { 0x81ab8d80, 0x22d1, 0x11d4, {0xa4, 0x36, 0x08, 0x00, 0x09, 0x63, 0x79, 0x94 }};

// Standard type names
LPCTSTR TYPENAME_TYPE      = _T("Type");
LPCTSTR TYPENAME_SYSTEM    = _T("System");
LPCTSTR TYPENAME_PALETTE   = _T("Palette");
LPCTSTR TYPENAME_CHARACTER = _T("Character");
LPCTSTR TYPENAME_BITMAP    = _T("Bitmap");
LPCTSTR TYPENAME_FONT      = _T("Font");
LPCTSTR TYPENAME_BOX       = _T("Box");
LPCTSTR TYPENAME_POINT     = _T("Point");
LPCTSTR TYPENAME_PATH      = _T("Path");
LPCTSTR TYPENAME_SPRITE    = _T("Sprite");
LPCTSTR TYPENAME_FRAME     = _T("Frame");
LPCTSTR TYPENAME_ANIMATION = _T("Animation");
LPCTSTR TYPENAME_MAP       = _T("Map");

// Standard computer system names
LPCTSTR NAME_SYSTEM_UNKNOWN     = _T("Unknown");
LPCTSTR NAME_SYSTEM_C64         = _T("Commodore 64");
LPCTSTR NAME_SYSTEM_AMIGA       = _T("Amiga");
LPCTSTR NAME_SYSTEM_ATARIST     = _T("Atari ST");
LPCTSTR NAME_SYSTEM_SINCLAIRQL  = _T("Sinclair QL");
LPCTSTR NAME_SYSTEM_GAMEGEAR    = _T("GameGear");
LPCTSTR NAME_SYSTEM_MASTER      = _T("Master System");
LPCTSTR NAME_SYSTEM_MEGADRIVE   = _T("Megadrive");
LPCTSTR NAME_SYSTEM_GAMEBOY     = _T("Gameboy");
LPCTSTR NAME_SYSTEM_NES         = _T("NES");
LPCTSTR NAME_SYSTEM_SNES        = _T("Super NES");
LPCTSTR NAME_SYSTEM_SNESMODE7   = _T("Super NES Mode 7");
LPCTSTR NAME_SYSTEM_PC          = _T("PC");
LPCTSTR NAME_SYSTEM_TARGA       = _T("Targa");

// Standard filename extensions
LPCTSTR FILEEXTENSION_XML		= _T(".xml");

LPCTSTR FILEEXTENSION_MAP		= _T(".map");
LPCTSTR FILEEXTENSION_BLK		= _T(".blk");
LPCTSTR FILEEXTENSION_COP		= _T(".cop");
LPCTSTR FILEEXTENSION_BOX		= _T(".box");
LPCTSTR FILEEXTENSION_FRK		= _T(".frk");
LPCTSTR FILEEXTENSION_PXP		= _T(".pxp");

LPCTSTR FILEEXTENSION_LBM		= _T(".lbm");
LPCTSTR FILEEXTENSION_PBM		= _T(".pbm");
LPCTSTR FILEEXTENSION_BBM		= _T(".bbm");
LPCTSTR FILEEXTENSION_PCX		= _T(".pcx");
LPCTSTR FILEEXTENSION_TGA		= _T(".tga");
LPCTSTR FILEEXTENSION_BMP		= _T(".bmp");

LPCTSTR FILEEXTENSION_CHR		= _T(".chr");
LPCTSTR FILEEXTENSION_SET		= _T(".set");
LPCTSTR FILEEXTENSION_GBC		= _T(".gbc");
LPCTSTR FILEEXTENSION_SF2		= _T(".sf2");
LPCTSTR FILEEXTENSION_SF4		= _T(".sf4");
LPCTSTR FILEEXTENSION_MCH		= _T(".mch");
LPCTSTR FILEEXTENSION_GCH		= _T(".gch");
LPCTSTR FILEEXTENSION_SCH		= _T(".sch");
LPCTSTR FILEEXTENSION_SF8		= _T(".sf8");
LPCTSTR FILEEXTENSION_SFB		= _T(".sfb");

// ----------------------------------------------------------------------------
// Colour palette for the Commodore 64
ChalkColour g_PaletteC64[16] = {
	0xff000000,	// Black
	0xffFFFFFF, // White
	0xffA00000, // Red
	0xff10D0D0, // Cyan
	0xffFF00FF, // Purple
	0xff00A000, // Green
	0xff2020FF, // Blue
	0xffE0E000, // Yellow
	0xffF07000, // Orange
	0xff603000, // Brown
	0xffFF2060, // Pink
	0xff404040, // Dark grey
	0xff808080, // Medium grey
	0xff40FF40, // Light green
	0xff8080FF, // Light blue
	0xffC0C0C0, // Light grey
};

// ----------------------------------------------------------------------------
// Colour palette for the Nintendo Entertainment System
ChalkColour g_PaletteNES[64] = {
	0xff9A9A9A,	/* 00 */
	0xff005FBE,
	0xff000ADF,
	0xff6545DF,
	0xff9F25EF,
	0xffC00095,
	0xffCA000F,
	0xff9B4F00,
	0xff807A00,
	0xff658A40,
	0xff2AA030,
	0xff5A905F,
	0xff007B90,
	0xff000000,
	0xff000000,
	0xff000000,

	0xffC0C0C0,	/* 10 */
	0xff0090FF,
	0xff6A64FF,
	0xff7040FF,
	0xffE575FF,
	0xffFF65C0,
	0xffFF0000,
	0xffDE700F,
	0xffD0C000,
	0xff85B055,
	0xff30CA3F,
	0xff20AB2F,
	0xff00A0DF,
	0xff000000,
	0xff000000,
	0xff000000,

	0xffFFFFFF,	/* 20 */
	0xff20C4FF,
	0xff2FB0FF,
	0xff9FAFFF,
	0xffFF9FFF,
	0xffFF9FDA,
	0xffFFA5A5,
	0xffFF9940,
	0xffFFEF00,
	0xff9FEF10,
	0xff10E500,
	0xff00E59F,
	0xff1BC0FF,
	0xff7A7A7A,
	0xff000000,
	0xff000000,

	0xffFFFFFF,	/* 30 */
	0xffCEEAFF,
	0xffD0DFFF,
	0xffEADFFF,
	0xffEAC5FF,
	0xffFFBFF0,
	0xffFFD5DA,
	0xffFFDFC5,
	0xffF5FFB6,
	0xffE0FFBF,
	0xffCFFFD0,
	0xff95FFDF,
	0xffBFEFFF,
	0xffE6E5E5,
	0xff000000,
	0xff000000,
};
