// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     Constants.h
// CREATED:  28 Apr 2000 by Carl Muller
// MODIFIED: 21 Apr 2001 by Carl Muller
//
// Declare some constants
// ----------------------------------------------------------------------------

// Colours
const ChalkColour COLOUR_TRANSPARENT = 0x00000000;
const ChalkColour COLOUR_BLACK       = 0xff000000;
const ChalkColour COLOUR_LTGREY      = 0xffc0c0c0;
const ChalkColour COLOUR_GREY        = 0xff808080;
const ChalkColour COLOUR_DKGREY      = 0xff505050;
const ChalkColour COLOUR_WHITE       = 0xffffffff;

const ChalkColour COLOUR_RED         = 0xffff0000;
const ChalkColour COLOUR_GREEN       = 0xff00ff00;
const ChalkColour COLOUR_BLUE        = 0xff0000ff;
const ChalkColour COLOUR_CYAN        = 0xff00ffff;
const ChalkColour COLOUR_MAGENTA     = 0xffff00ff;
const ChalkColour COLOUR_YELLOW      = 0xffffff00;

const ChalkColour COLOUR_DKRED       = 0xff800000;
const ChalkColour COLOUR_DKGREEN     = 0xff008000;
const ChalkColour COLOUR_DKBLUE      = 0xff000080;
const ChalkColour COLOUR_DKCYAN      = 0xff008080;
const ChalkColour COLOUR_DKMAGENTA   = 0xff800080;
const ChalkColour COLOUR_DKYELLOW    = 0xff808000;

// Standard format specifiers
extern LPCTSTR FORMAT_EMPTY;
extern LPCTSTR FORMAT_SPACE;
extern LPCTSTR FORMAT_DECIMAL;
extern LPCTSTR FORMAT_PERCENT;
extern LPCTSTR FORMAT_HEX2;
extern LPCTSTR FORMAT_HEX4;
extern LPCTSTR FORMAT_HEX8;

// Standard type GUIDs
extern const GUID GUID_VOID;      // A void GUID
extern const GUID GUID_TYPE;      // The guid of the type object for type
extern const GUID GUID_SYSTEM;    // The guid of the type object for computer system
extern const GUID GUID_PALETTE;   // The guid of the type object for palettes
extern const GUID GUID_CHARACTER; // The guid of the type object for a character
extern const GUID GUID_BITMAP;    // The guid of the type object for a bitmap
extern const GUID GUID_BOX;       // The guid of the type object for a box
extern const GUID GUID_POINT;     // The guid of the type object for a point
extern const GUID GUID_PATH;      // The guid of the type object for a path
extern const GUID GUID_SPRITE;    // The guid of the type object for a sprite
extern const GUID GUID_FRAME;     // The guid of the type object for a frame
extern const GUID GUID_ANIMATION; // The guid of the type object for a animation
extern const GUID GUID_FONT;      // The guid of the type object for a font
extern const GUID GUID_MAP;       // The guid of the type object for a map animation

// GUIDs for standard computer systems
extern const GUID GUID_SYSTEM_UNKNOWN;
extern const GUID GUID_SYSTEM_C64;
extern const GUID GUID_SYSTEM_AMIGA;
extern const GUID GUID_SYSTEM_ATARIST;
extern const GUID GUID_SYSTEM_SINCLAIRQL;
extern const GUID GUID_SYSTEM_GAMEGEAR;
extern const GUID GUID_SYSTEM_MASTER;
extern const GUID GUID_SYSTEM_MEGADRIVE;
extern const GUID GUID_SYSTEM_GAMEBOY;
extern const GUID GUID_SYSTEM_NES;
extern const GUID GUID_SYSTEM_SNES;
extern const GUID GUID_SYSTEM_SNESMODE7;
extern const GUID GUID_SYSTEM_PC;
extern const GUID GUID_SYSTEM_TARGA;

// Standard type names
extern LPCTSTR TYPENAME_TYPE;
extern LPCTSTR TYPENAME_SYSTEM;
extern LPCTSTR TYPENAME_PALETTE;
extern LPCTSTR TYPENAME_CHARACTER;
extern LPCTSTR TYPENAME_BITMAP;
extern LPCTSTR TYPENAME_BOX;
extern LPCTSTR TYPENAME_POINT;
extern LPCTSTR TYPENAME_PATH;
extern LPCTSTR TYPENAME_SPRITE;
extern LPCTSTR TYPENAME_FRAME;
extern LPCTSTR TYPENAME_ANIMATION;
extern LPCTSTR TYPENAME_FONT;
extern LPCTSTR TYPENAME_MAP;

// Standard computer system names
extern LPCTSTR NAME_SYSTEM_UNKNOWN;
extern LPCTSTR NAME_SYSTEM_C64;
extern LPCTSTR NAME_SYSTEM_AMIGA;
extern LPCTSTR NAME_SYSTEM_ATARIST;
extern LPCTSTR NAME_SYSTEM_SINCLAIRQL;
extern LPCTSTR NAME_SYSTEM_GAMEGEAR;
extern LPCTSTR NAME_SYSTEM_MASTER;
extern LPCTSTR NAME_SYSTEM_MEGADRIVE;
extern LPCTSTR NAME_SYSTEM_GAMEBOY;
extern LPCTSTR NAME_SYSTEM_NES;
extern LPCTSTR NAME_SYSTEM_SNES;
extern LPCTSTR NAME_SYSTEM_SNESMODE7;
extern LPCTSTR NAME_SYSTEM_PC;
extern LPCTSTR NAME_SYSTEM_TARGA;

// Standard filename extensions
extern LPCTSTR FILEEXTENSION_XML;

extern LPCTSTR FILEEXTENSION_MAP;
extern LPCTSTR FILEEXTENSION_BLK;
extern LPCTSTR FILEEXTENSION_COP;
extern LPCTSTR FILEEXTENSION_BOX;
extern LPCTSTR FILEEXTENSION_FRK;
extern LPCTSTR FILEEXTENSION_PXP;

extern LPCTSTR FILEEXTENSION_LBM;
extern LPCTSTR FILEEXTENSION_PBM;
extern LPCTSTR FILEEXTENSION_BBM;
extern LPCTSTR FILEEXTENSION_PCX;
extern LPCTSTR FILEEXTENSION_TGA;
extern LPCTSTR FILEEXTENSION_BMP;

extern LPCTSTR FILEEXTENSION_CHR;
extern LPCTSTR FILEEXTENSION_SET;
extern LPCTSTR FILEEXTENSION_GBC;
extern LPCTSTR FILEEXTENSION_SF2;
extern LPCTSTR FILEEXTENSION_SF4;
extern LPCTSTR FILEEXTENSION_MCH;
extern LPCTSTR FILEEXTENSION_GCH;
extern LPCTSTR FILEEXTENSION_SCH;
extern LPCTSTR FILEEXTENSION_SF8;
extern LPCTSTR FILEEXTENSION_SFB;

// Standard fixed palettes
extern ChalkColour g_PaletteC64[16]; // Commodore 64 palette
extern ChalkColour g_PaletteNES[64]; // Nintendo Entertainment System palette
