// ----------------------------------------------------------------------------
// CHALK (c) 2000, 2001 Carl Muller.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public License
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program, as the file license.txt; if not, write to
// the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//
// FILE:     Filename.h
// CREATED:  30 Apr 2000 by Carl Muller
// MODIFIED: 24 Oct 2001 by Carl Muller
//
// Defines the filename class
// ----------------------------------------------------------------------------

#pragma warning(disable: 4018) // Don't show signed/unsigned mismatches

#ifdef _UNICODE
typedef wstring tstring;
typedef wstringstream tstringstream;
#else
typedef string tstring;
typedef stringstream tstringstream;
#endif

// Convert 8 bits to 16
wstring WidenString(const string& value);
wstring WidenString(const vector<BYTE>& value);
string NarrowString(const wstring& value);
wstring MakeUpper(const wstring& value);

// Special name compare (handles embedded numbers)
int CompareFileNames(const wstring& str1, const wstring& str2);

// ----------------------------------------------------------------------------
// A file name
class CFileName
{
	public:
		CFileName() {}
		CFileName(const string& filename) { Set(filename); }
		CFileName(const wstring& filename) { Set(filename); }
		CFileName(const CFileName& filename) { Set(filename.Get()); }
		~CFileName() { Clear(); }
		const CFileName& operator= (const CFileName& that) { Set(that.Get()); return *this; }

		void Clear();
		void Set(const string& filename);
		void Set(const wstring& filename);
		void AddDir(const wstring& newdir);
		void MakeAbsolute();

		bool HasExt(const string& ext) const;
		bool HasExt(const wstring& ext) const;
		bool IsValid() const    { return !m_Name.empty(); }
		wstring Get() const      { return m_Drive + m_Dir + m_Name + m_Ext; }
		wstring GetDrive() const { return m_Drive; }  // C: or \\SERVER\SHARED
		wstring GetDir() const   { return m_Dir; }    // \  or \graphics
		wstring GetName() const  { return m_Name; }   // thefilename
		wstring GetExt() const   { return m_Ext; }    // .lbm
		void SetDrive(const wstring& newdrive) { m_Drive = newdrive; }
		void SetDir(const wstring& newdir)     { m_Dir = newdir; }
		void SetName(const wstring& newname)   { m_Name = newname; }
		void SetExt(const wstring& newext)     { m_Ext = newext; }

		// Static functions
		static wstring MakeRelative(const wstring& basepath, const wstring& newpath);
		static wstring MakeAbsolute(const wstring& basepath, const string& offset);
		static wstring MakeAbsolute(const wstring& basepath, const wstring& offset);
		static wstring MakeRelative(const CFileName& basepath, const CFileName& newpath)
		{ return MakeRelative(basepath.Get(), newpath.Get()); }
		static wstring MakeAbsolute(const CFileName& basepath, const string& offset)
		{ return MakeAbsolute(basepath.Get(), offset); }
		static wstring MakeAbsolute(const CFileName& basepath, const wstring& offset)
		{ return MakeAbsolute(basepath.Get(), offset); }
		static long FileSize(const wstring& filename);
		static bool FileLocked(const wstring& filename);
		static bool FileExists(const wstring& filename);
		static bool HasWildcard(const wstring& filename);

	private:
		// Main data
		wstring m_Drive; // Drive or UNC share
		wstring m_Dir;   // Directory path
		wstring m_Name;  // Base filename
		wstring m_Ext;   // File extension
};
